/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdc_server.c,v $
 *
 *
 *  MODULE NAME:    cdc_server.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <sgtty.h>
#include <syslog.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <ctype.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "cdc_db.h"
#include "prot.h"

extern int errno;

struct sockaddr_in sin = {AF_INET};
int     f, t;

char *progname;
static struct timeval cdc_time;
static char         cdc_domain[FULLNAME_SZ];
static int          cdc_domainlen;
static char         s_instance[2*ANAME_SZ];

/* statistics */
static long q_bytes;            /* current bytes remaining in queue */
                                /* q_bytes   */
static long max_age = -1;

extern int optind, opterr;
extern char *optarg;

#define ACCEPT_CNT_LOG   200

char   *progname, *rindex();
static void check_db_age();

main(argc, argv)
    int     argc;
    char  **argv;
{
    struct sockaddr_in from;
    struct hostent     *hp, hostent;
    register int n;
    int     on = 1, debugflag = 0, dflag = 0, c, errflg = 0;
    char    *cp, *database, *t_str;
    struct servent *sp;
    int     fromlen, length, i, now;
    static KTEXT_ST pkt_st;
    KTEXT   pkt = &pkt_st;

    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

    opterr = 0;
    while ((c=getopt(argc, argv, "vd:")) != EOF)
      switch(c) {
        case 'v' :
	  debugflag = 1;
	  break;
	case 'd' :
	  dflag = 1;
	  database = optarg;
	  break;
	case '?' :
	  errflg++;
	}
    
    if (errflg) {
      fprintf(stderr, "Usage: %s [-v] [-d database-name]\n", progname);
      exit(1);
    }

    if (dflag == 0)  database = DBM_FILE;

    if (cdc_db_set_name(database) != 0) exit(-1);


    /* find our hostname, and use it as the instance */
    if (gethostname(s_instance, ANAME_SZ)) {
      fprintf(stderr, "%s: gethostname error\n", progname);
      exit(1);
    }

    strcpy(cdc_domain, get_domain_name(NULL));
    cdc_domainlen = strlen(cdc_domain);
    printf("CDC server for domain '%s' on %s\n", cdc_domain, s_instance);
    
    if ((sp = getservbyname("cdc", "tcp")) == 0) {
      fprintf(stderr, "%s: tcp/cdc unknown service\n", progname);
      exit(1);
    }

    if ((hp=gethostbyname(s_instance)) == NULL) {
      printf("cannot get local host info for '%s'\n", s_instance);
      exit(1);
    }

    sin.sin_port = sp->s_port;
    bcopy((char *)hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
    sin.sin_family = hp->h_addrtype;

    if ((f = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      fprintf(stderr, "%s: Can't open socket\n", progname);
      exit(1);
    }

    if (bind(f, &sin, S_AD_SZ, 0) < 0) {
      fprintf(stderr, "%s: Can't bind socket\n", progname);
      exit(1);
    }
    /* do all the database and cache inits */
    if (n = cdc_db_init()) {
      printf("CDC db and cache init ");
      printf("failed = %d ...exiting\n", n);
      exit(-1);
    }

    /*  Make sure database isn't stale  */
    check_db_age();

    listen(f, 5);

    /* receive loop */
    for (;;) {
	fromlen = S_AD_SZ;
	while ((t=accept(f, &from, &fromlen)) < 0) {
          if (errno != EINTR) {
	    syslog(LOG_INFO, "cdc_server : error accept - %d ; errno is %d", t, errno);
	    printf("cdc_server : error accept - %d ; errno is %d\n", t, errno);
	    exit(0);
          }
	}
	n = read(t, pkt->dat, MAX_PKT_LEN);

	length = DecodeTotalLength((char *)(pkt->dat));

	while (n < length) {
	  if ((i = read(t, &pkt->dat[n], MAX_PKT_LEN-n)) > 0)
	    n = n + i;
	}

	if (n > 0) {
	    pkt->length = n;
	    pkt->mbz = 0; /* force zeros to catch runaway strings */
	    /* see what is left in the input queue */
	    ioctl(f, FIONREAD, &q_bytes);
	    gettimeofday(&cdc_time, NULL);
if (debugflag) {
  hp = gethostbyaddr(&from.sin_addr, sizeof(struct in_addr), from.sin_family);
  if (hp == 0)
    hp = &hostent;
  hp->h_name = (char *) inet_ntoa(from.sin_addr);
  now = time(0);
  t_str = (char *) ctime(&now);
  printf("pkt received from %s (length %d) on %s", hp->h_name, n, t_str);
  free(t_str);
  cdb_hexdump(pkt->dat, n);
}
	    cdc_process(&from, pkt, debugflag);
	}
    }
}


cdc_process(client, pkt, debugflag)
    struct sockaddr_in *client;
    KTEXT   pkt;
    int     debugflag;
{
    static KTEXT_ST rpkt_st;
    KTEXT  rpkt = &rpkt_st;
    int    type, cc;

    type = check_req_apdu(cdc_domain, pkt, rpkt, debugflag);
    if (debugflag) {
      printf("response pkt at CDC (len is %d) is :\n", rpkt->length);
      cdb_hexdump(rpkt->dat, rpkt->length);
      printf("\n");
    }

    cc = write(t, rpkt->dat, rpkt->length);

    close(t);
}

/*
 * setup_disc 
 *
 * disconnect all descriptors, remove ourself from the process
 * group that spawned us. 
 */

setup_disc()
{

    int     s;

    for (s = 0; s < 3; s++) {
	(void) close(s);
    }

    (void) open("/dev/null", 0);
    (void) dup2(0, 1);
    (void) dup2(0, 2);

    s = open("/dev/tty", 2);

    if (s >= 0) {
	ioctl(s, TIOCNOTTY, (struct sgttyb *) 0);
	(void) close(s);
    }
    (void) chdir("/tmp");
    return;
}

/*
 * Make sure that database isn't stale.
 *
 * Exit if it is; we don't want to tell lies.
 */

static void check_db_age()
{
    long age;
    
    if (max_age != -1) {
	/* Requires existance of cdc_get_db_age() */
	gettimeofday(&cdc_time, 0);
	age = cdc_get_db_age();
	if (age == 0) {
	    syslog(LOG_INFO, "cdc_server : Database currently being updated! - exit for now.");
	    printf("Database currently being updated! - exit for now.");
	    exit(-1);
	}
	if ((age + max_age) < cdc_time.tv_sec) {
	    syslog(LOG_INFO, "cdc_server : Database out of date! - exit for now.");
	    printf("Database out of date! - exit for now.");
	    exit(-1);
	    /* NOTREACHED */
	}
    }
}
