/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/os/RCS/strcmp_support.c,v $
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "cdc.h"

static  char s1_buf[FULLNAME_SZ], s2_buf[FULLNAME_SZ];
int     j1, j2;

int strcmp_support(s1, s2)
char *s1, *s2;
{
  int  i, c;

  j1 = strlen(s1);
  j2 = strlen(s2);
  bzero(s1_buf, j1);
  bzero(s2_buf, j2);

  strcpy(s1_buf, s1);
  for (i=0;i<j1;i++) {
    c = s1_buf[i];
    if (islower(c)) s1_buf[i] = toupper(c);
  }

  strcpy(s2_buf, s2);
  for (i=0;i<j2;i++) {
    c = s2_buf[i];
    if (islower(c)) s2_buf[i] = toupper(c);
  }

  return(strcmp(s1_buf, s2_buf));
}

int strncmp_support(s1, s2, len)
char *s1, *s2;
int  len;
{
  int  i, c;

  j1 = strlen(s1);
  j2 = strlen(s2);
  bzero(s1_buf, j1);
  bzero(s2_buf, j2);

  strcpy(s1_buf, s1);
  if (len < j1) j1 = len;
  for (i=0;i<j1;i++) {
    c = s1_buf[i];
    if (islower(c)) s1_buf[i] = toupper(c);
  }

  strcpy(s2_buf, s2);
  if (len < j2) j2 = len;
  for (i=0;i<j2;i++) {
    c = s2_buf[i];
    if (islower(c)) s2_buf[i] = toupper(c);
  }

  return(strncmp(s1_buf, s2_buf, len));
}
