/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/rdn_manip.c,v $
 *
 *
 *  MODULE NAME:    rdn_manip.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"

#ifdef sun
#define strcasecmp       strcmp_support
#endif

print_rdn(name)
struct type_SPHINX_Name *name;
{
  struct type_SPHINX_RDN    *rdn;
  struct type_SPHINX_AttributeValueAssertion  *ava;

  for (name; name; name = name->next) {
    rdn = name->RDN;
    if (rdn->next) {
      printf("\t\t{  ");
      for (rdn ; rdn; rdn = rdn->next) {
	ava = rdn->AttributeValueAssertion;
	printf("%s ", oid_to_abbrev(sprintoid(ava->type)));
	if (strlen(oid_to_abbrev(sprintoid(ava->type))) == 1) printf(" ");
	printf("= %s", qb2str(ava->value->un.string));
	if(rdn->next) printf(",\n\t\t   ");
        }
      printf("  }\n");
      }
    else {
      ava = rdn->AttributeValueAssertion;
      printf("\t\t%s=", oid_to_abbrev(sprintoid(ava->type)));
      if (strlen(oid_to_abbrev(sprintoid(ava->type))) == 1) printf(" ");
      printf("%s", qb2str(ava->value->un.string));
      if (name->next)  printf(",\n ");
    }
  }
}


int rdn_cmp(n1,n2)
struct type_SPHINX_Name *n1, *n2;
{
    struct type_SPHINX_RDN *n1_rdn, *n2_rdn;
    struct type_SPHINX_AttributeValueAssertion *n1_ava, *n2_ava;
    struct type_SPHINX_AttributeValue *n1_av, *n2_av;
    char *n1_str, *n2_str;
    int i;

    for(;n1;n1=n1->next,n2=n2->next) {
	if(n2==NULL)return(1);
	n1_rdn = n1->RDN;
	n2_rdn = n2->RDN;
	for(;n1_rdn;n1_rdn=n1_rdn->next,n2_rdn=n2_rdn->next) {
		if(n2_rdn == NULL) return(1);
		n1_ava=n1_rdn->AttributeValueAssertion;
		n2_ava=n2_rdn->AttributeValueAssertion;
		i=oid_cmp(n1_ava->type,n2_ava->type);
		if (i!=0) return(i);
		n1_av = n1_ava->value;
		n2_av = n2_ava->value;
		i = n1_av->offset;
		if(i != n2_av->offset) return(1);
		switch(i) {
		case type_SPHINX_CaseIgnoreString_t61 :
			n1_str = qb2str(n1_av->un.t61);
			n2_str = qb2str(n2_av->un.t61);
			break;
		case type_SPHINX_CaseIgnoreString_string :
			n1_str = qb2str(n1_av->un.string);
			n2_str = qb2str(n2_av->un.string);
			break;
		default:
			return(-1);  /* don't really know */
		}
		if(i = strcasecmp(n1_str, n2_str)) 
			if (i>0) return(1); else return(-1);
	}
	if(n2_rdn) return(-1);
    }
    if(n2)return(-1);
    return(0);				
}
