/*
 * $Source: /mit/kerberos/src/lib/krb/RCS/krb_get_in_tkt.c,v $
 * $Author: jtkohl $
 *
 * Copyright 1986, 1987, 1988 by the Massachusetts Institute
 * of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 */

#ifndef lint
static char *rcsid_krb_get_in_tkt_c =
"$Header: krb_get_in_tkt.c,v 4.19 89/07/18 16:31:31 jtkohl Exp $";
#endif /* lint */

#include <mit-copyright.h>
#include <krb.h>
#include <des.h>
#include <prot.h>

#include <stdio.h>
#include <strings.h>
#include <errno.h>

/* use the bsd time.h struct defs for PC too! */
#include <sys/time.h>
#include <sys/types.h>

#ifdef SUPPORT_PUBKEY

/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "gssapi_defs.h"
#endif

int     swap_bytes;

#ifdef SUPPORT_PUBKEY
static int fixup_key(user,instance,realm,oldkey,key)
    char *user, *instance, *realm, *oldkey;
    C_Block key;
{
    if (oldkey) {
        bcopy(oldkey, key, 8);
	des_fixup_key_parity(key);
    }
    return (0);
}
#endif
/*
 * decrypt_tkt(): Given user, instance, realm, passwd, key_proc
 * and the cipher text sent from the KDC, decrypt the cipher text
 * using the key returned by key_proc.
 */

static int decrypt_tkt(user, instance, realm, arg, key_proc, cipp)
  char *user;
  char *instance;
  char *realm;
  char *arg;
  int (*key_proc)();
  KTEXT *cipp;
{
    KTEXT cip = *cipp;
    C_Block key;		/* Key for decrypting cipher */
    Key_schedule key_s;

#ifndef NOENCRYPTION
    /* Attempt to decrypt it */
#endif
    
    /* generate a key */
    
    {
	register int rc;
	rc = (*key_proc)(user,instance,realm,arg,key);
	if (rc)
	    return(rc);
    }
    
#ifndef NOENCRYPTION
    key_sched(key,key_s);
    pcbc_encrypt((C_Block *)cip->dat,(C_Block *)cip->dat,
		 (long) cip->length,key_s,key,0);
#endif /* !NOENCRYPTION */
    /* Get rid of all traces of key */
    bzero((char *)key,sizeof(key));
    bzero((char *)key_s,sizeof(key_s));

    return(0);
}

/*
 * krb_get_in_tkt() gets a ticket for a given principal to use a given
 * service and stores the returned ticket and session key for future
 * use.
 *
 * The "user", "instance", and "realm" arguments give the identity of
 * the client who will use the ticket.  The "service" and "sinstance"
 * arguments give the identity of the server that the client wishes
 * to use.  (The realm of the server is the same as the Kerberos server
 * to whom the request is sent.)  The "life" argument indicates the
 * desired lifetime of the ticket; the "key_proc" argument is a pointer
 * to the routine used for getting the client's private key to decrypt
 * the reply from Kerberos.  The "decrypt_proc" argument is a pointer
 * to the routine used to decrypt the reply from Kerberos; and "arg"
 * is an argument to be passed on to the "key_proc" routine.
 *
 * If all goes well, krb_get_in_tkt() returns INTK_OK, otherwise it
 * returns an error code:  If an AUTH_MSG_ERR_REPLY packet is returned
 * by Kerberos, then the error code it contains is returned.  Other
 * error codes returned by this routine include INTK_PROT to indicate
 * wrong protocol version, INTK_BADPW to indicate bad password (if
 * decrypted ticket didn't make sense), INTK_ERR if the ticket was for
 * the wrong server or the ticket store couldn't be initialized.
 *
 * The format of the message sent to Kerberos is as follows:
 *
 * Size			Variable		Field
 * ----			--------		-----
 *
 * 1 byte		KRB_PROT_VERSION	protocol version number
 * 1 byte		AUTH_MSG_KDC_REQUEST |	message type
 *			HOST_BYTE_ORDER		local byte order in lsb
 * string		user			client's name
 * string		instance		client's instance
 * string		realm			client's realm
 * 4 bytes		tlocal.tv_sec		timestamp in seconds
 * 1 byte		life			desired lifetime
 * string		service			service's name
 * string		sinstance		service's instance
 *
 *
 **************************************************************************
 ***************   ONLY IF COMPILED WITH SUPPORT_PUBKEY  ******************
 **************************************************************************
 *
 * The format of the message sent to Kerberos (using SPX) is as follows:
 *
 * Size			Variable		  Field
 * ----			--------		  -----
 *
 * 1 byte	KRB_PROT_VERSION	         protocol version number
 * 1 byte	AUTH_MSG_KDC_REQ_USING_SPX |     message type
 *		HOST_BYTE_ORDER		         local byte order in lsb
 * 2 bytes	token_length		         length of auth token
 * n bytes	token			         client's auth token
 * string	realm			         server's realm
 * 4 bytes	tlocal.tv_sec		         timestamp in seconds
 * 1 byte	life			         desired lifetime
 * string	service			         service's name
 * string	sinstance		         service's instance
 *
 *
 */

krb_get_in_tkt(user, instance, realm, service, sinstance, life,
	       key_proc, decrypt_proc, arg)
    char *user;
    char *instance;
    char *realm;
    char *service;
    char *sinstance;
    int life;
    int (*key_proc)();
    int (*decrypt_proc)();
    char *arg;
{
    KTEXT_ST pkt_st;
    KTEXT pkt = &pkt_st;	/* Packet to KDC */
    KTEXT_ST rpkt_st;
    KTEXT rpkt = &rpkt_st;	/* Returned packet */
    KTEXT_ST cip_st;
    KTEXT cip = &cip_st;	/* Returned Ciphertext */
    KTEXT_ST tkt_st;
    KTEXT tkt = &tkt_st;	/* Current ticket */
    C_Block ses;                /* Session key for tkt */
    int kvno;			/* Kvno for session key */
    unsigned char *v = pkt->dat; /* Prot vers no */
    unsigned char *t = (pkt->dat+1); /* Prot msg type */

    char s_name[SNAME_SZ];
    char s_instance[INST_SZ];
    char rlm[REALM_SZ];
    int lifetime;
    int msg_byte_order;
    int kerror;
    unsigned long exp_date;
    char *ptr;
    struct timeval t_local;
    unsigned long rep_err_code;
    unsigned long kdc_time;   /* KDC time */
#ifdef SUPPORT_PUBKEY
/*
 *  GSS API support
 */
    int           from_addr = 0, to_addr = 0, using_pubkey = 0;
    char          targ_printable[GSS_C_MAX_PRINTABLE_NAME];
    char          *address, *cp, keybuf[8];
    int           major_status, mech_status;
    gss_OID       actual_mech_type;
    gss_ctx_id_t  actual_ctxhandle;
    int           msg_ctx = 0, new_status;
    int           req_flags = 0, ret_flags, lifetime_rec;
    gss_buffer_desc  output_token, input_name_buffer;
    gss_buffer_desc  status_string;
    gss_name_t    desired_targname;
    gss_channel_bindings  input_chan_bindings;
    char          localuser[ANAME_SZ], localinst[INST_SZ];
    char          myhost[80];
    struct sockaddr_in  sin2;
    struct hostent   *my_hp;
#endif

    /* BUILD REQUEST PACKET */

    /* Set up the fixed part of the packet */
    *v = (unsigned char) KRB_PROT_VERSION;
    *t = (unsigned char) AUTH_MSG_KDC_REQUEST;
#ifdef SUPPORT_PUBKEY
    if (*user == NULL) {
      using_pubkey = 1;
      *t = (unsigned char) AUTH_MSG_KDC_REQUEST_USING_SPX;
    }
#endif
    *t |= HOST_BYTE_ORDER;

#ifdef SUPPORT_PUBKEY
    if (using_pubkey) {
      strcpy(targ_printable, "SERVICE:krbtgt@");
      /*
       *  need the Internet hostname for the kerberos service in this realm.
       */
      strcat(targ_printable, realm);

      input_name_buffer.length = strlen(targ_printable);
      input_name_buffer.value = targ_printable;

      major_status = gss_import_name(&mech_status,
				     &input_name_buffer,
				     GSS_C_NULL_OID,
				     &desired_targname);

      input_chan_bindings = (gss_channel_bindings)
	malloc(sizeof(gss_channel_bindings_desc));

      gethostname(myhost, sizeof(myhost));
      my_hp=gethostbyname(myhost);
      if (my_hp != 0) {
	bcopy(my_hp->h_addr_list[0],
	      (caddr_t)&sin2.sin_addr, my_hp->h_length);
	from_addr = sin2.sin_addr.S_un.S_addr;
	from_addr = htonl(from_addr);
      }

      input_chan_bindings->initiator_addrtype = GSS_C_AF_INET;
      input_chan_bindings->initiator_address.length = 4;
      address = (char *) malloc(4);
      input_chan_bindings->initiator_address.value = (char *) address;
      address[0] = ((from_addr & 0xff000000) >> 24);
      address[1] = ((from_addr & 0xff0000) >> 16);
      address[2] = ((from_addr & 0xff00) >> 8);
      address[3] = (from_addr & 0xff);
      input_chan_bindings->acceptor_addrtype = GSS_C_AF_INET;
      input_chan_bindings->acceptor_address.length = 4;
      address = (char *) malloc(4);
      input_chan_bindings->acceptor_address.value = (char *) address;
      address[0] = 0;
      address[1] = 0;
      address[2] = 0;
      address[3] = 0;
      input_chan_bindings->application_data.length = 0;

      req_flags = 0;   /* don't want mutual or deleg */

      major_status = gss_init_sec_context(&mech_status,    /* minor status */
				GSS_C_NO_CREDENTIAL,       /* cred handle */
				&actual_ctxhandle,         /* ctx handle */
				desired_targname,          /* target name */
				GSS_C_NULL_OID,            /* mech type */
				req_flags,                 /* req flags */
				0,                         /* time req */
				input_chan_bindings,       /* chan binding */
				GSS_C_NO_BUFFER,           /* input token */
				&actual_mech_type,         /* actual mech */
				&output_token,             /* output token */
                                &ret_flags,                /* ret flags */
                                &lifetime_rec);            /* time rec */


      if (major_status!=GSS_S_COMPLETE) {
	gss_display_status(&new_status,
			   mech_status,
			   GSS_C_MECH_CODE,
			   GSS_C_NULL_OID,
			   &msg_ctx,
			   &status_string);
	printf("%s\n", status_string.value);
	return(INTK_ERR);
      }
      pkt->length = 2;
      cp = (char *) (pkt->dat+2);
      *cp = ((output_token.length & 0xff00) >> 8);
      *cp++;
      pkt->length++;
      *cp = (output_token.length & 0xff);
      *cp++;
      pkt->length++;
      bcopy(output_token.value, cp, output_token.length);
      pkt->length += output_token.length;
    } else {
#endif
      /* Now for the variable info */
      (void) strcpy((char *)(pkt->dat+2),user); /* aname */
      pkt->length = 3 + strlen(user);
      (void) strcpy((char *)(pkt->dat+pkt->length),
		    instance);	/* instance */
      pkt->length += 1 + strlen(instance);
#ifdef SUPPORT_PUBKEY
    }
#endif

    (void) strcpy((char *)(pkt->dat+pkt->length),realm); /* realm */
    pkt->length += 1 + strlen(realm);

    (void) gettimeofday(&t_local,(struct timezone *) 0);
    /* timestamp */
    bcopy((char *)&(t_local.tv_sec),(char *)(pkt->dat+pkt->length), 4);
    pkt->length += 4;

    *(pkt->dat+(pkt->length)++) = (char) life;
    (void) strcpy((char *)(pkt->dat+pkt->length),service);
    pkt->length += 1 + strlen(service);
    (void) strcpy((char *)(pkt->dat+pkt->length),sinstance);
    pkt->length += 1 + strlen(sinstance);

    rpkt->length = 0;

    /* SEND THE REQUEST AND RECEIVE THE RETURN PACKET */

    if (kerror = send_to_kdc(pkt, rpkt, realm)) return(kerror);

    /* check packet version of the returned packet */
    if (pkt_version(rpkt) != KRB_PROT_VERSION)
        return(INTK_PROT);

    /* Check byte order */
    msg_byte_order = pkt_msg_type(rpkt) & 1;
    swap_bytes = 0;
    if (msg_byte_order != HOST_BYTE_ORDER) {
        swap_bytes++;
    }

    switch (pkt_msg_type(rpkt) & ~1) {
    case AUTH_MSG_KDC_REPLY:
        break;
    case AUTH_MSG_ERR_REPLY:
        bcopy(pkt_err_code(rpkt),(char *) &rep_err_code,4);
        if (swap_bytes) swap_u_long(rep_err_code);
#ifdef SUPPORT_PUBKEY
	if (using_pubkey)
	  printf("%s\n", pkt_err_text(rpkt));
#endif
        return((int)rep_err_code);
    default:
        return(INTK_PROT);
    }

    /* EXTRACT INFORMATION FROM RETURN PACKET */
#ifdef SUPPORT_PUBKEY
    if (using_pubkey) {
      strcpy(localuser, rpkt->dat+2);
      strcpy(localinst, rpkt->dat+strlen(localuser)+3);
      user = &localuser[0];
      instance = &localinst[0];
    }
#endif

    /* get the principal's expiration date */
    bcopy(pkt_x_date(rpkt),(char *) &exp_date,sizeof(exp_date));
    if (swap_bytes) swap_u_long(exp_date);

    /* Extract the ciphertext */
    cip->length = pkt_clen(rpkt);       /* let clen do the swap */

    if ((cip->length < 0) || (cip->length > sizeof(cip->dat)))
	return(INTK_ERR);		/* no appropriate error code
					 currently defined for INTK_ */
    /* copy information from return packet into "cip" */
    bcopy((char *) pkt_cipher(rpkt),(char *)(cip->dat),cip->length);

#ifdef SUPPORT_PUBKEY
    if (using_pubkey) {
      major_status = gss__extract_key_from_context(actual_ctxhandle,
						   (char *) keybuf);
      arg = (char *) &keybuf[0];
      key_proc = fixup_key;
    }
#endif
    /* Attempt to decrypt the reply. */
    if (decrypt_proc == NULL)
	decrypt_proc = decrypt_tkt;
    (*decrypt_proc)(user, instance, realm, arg, key_proc, &cip);

    ptr = (char *) cip->dat;

    /* extract session key */
    bcopy(ptr,(char *)ses,8);
    ptr += 8;

    if ((strlen(ptr) + (ptr - (char *) cip->dat)) > cip->length)
	return(INTK_BADPW);

    /* extract server's name */
    (void) strcpy(s_name,ptr);
    ptr += strlen(s_name) + 1;

    if ((strlen(ptr) + (ptr - (char *) cip->dat)) > cip->length)
	return(INTK_BADPW);

    /* extract server's instance */
    (void) strcpy(s_instance,ptr);
    ptr += strlen(s_instance) + 1;

    if ((strlen(ptr) + (ptr - (char *) cip->dat)) > cip->length)
	return(INTK_BADPW);

    /* extract server's realm */
    (void) strcpy(rlm,ptr);
    ptr += strlen(rlm) + 1;

    /* extract ticket lifetime, server key version, ticket length */
    /* be sure to avoid sign extension on lifetime! */
    lifetime = (unsigned char) ptr[0];
    kvno = (unsigned char) ptr[1];
    tkt->length = (unsigned char) ptr[2];
    ptr += 3;
    
    if ((tkt->length < 0) ||
	((tkt->length + (ptr - (char *) cip->dat)) > cip->length))
	return(INTK_BADPW);

    /* extract ticket itself */
    bcopy(ptr,(char *)(tkt->dat),tkt->length);
    ptr += tkt->length;

    if (strcmp(s_name, service) || strcmp(s_instance, sinstance) ||
        strcmp(rlm, realm))	/* not what we asked for */
	return(INTK_ERR);	/* we need a better code here XXX */

    /* check KDC time stamp */
    bcopy(ptr,(char *)&kdc_time,4); /* Time (coarse) */
    if (swap_bytes) swap_u_long(kdc_time);

    ptr += 4;

    (void) gettimeofday(&t_local,(struct timezone *) 0);
    if (abs((int)(t_local.tv_sec - kdc_time)) > CLOCK_SKEW) {
        return(RD_AP_TIME);		/* XXX should probably be better
					   code */
    }

    /* initialize ticket cache */
    if (in_tkt(user,instance) != KSUCCESS)
	return(INTK_ERR);

    /* stash ticket, session key, etc. for future use */
    if (kerror = save_credentials(s_name, s_instance, rlm, ses,
				  lifetime, kvno, tkt, t_local.tv_sec))
	return(kerror);

    return(INTK_OK);
}
