if not IsBound( InfoRead1 )  then InfoRead1 := Ignore;  fi;

ReadLocal := function ( name )
    local   readIndent;
    readIndent := ReadIndent;
    ReadIndent := ConcatenationString( ReadIndent, "  " );
    InfoRead1( "#I",ReadIndent,"ReadLib( \"", name, "\" )\n" );
    if not READ( ConcatenationString( LOCALNAME, name, ".g" ) )  then
        Error("the library file '",name,"' must exist and be readable");
    fi;
    ReadIndent := readIndent;
    if ReadIndent = ""  then
        InfoRead1( "#I  ReadLib( \"", name, "\" ) done\n" );
    fi;
end;

AUTO( ReadLocal( "absreducible" ),
  FrobAction, CompleteBasis, IsAbsIrredGMod, UndoAbsIrredFlags,
  FieldGenCentMat );

AUTO( ReadLocal( "c_dualmod" ),
  DualGMod );

AUTO( ReadLocal( "c_induced" ),
  StrongGenImages, EltImage, StrongGenImagesCall, InducedGMod, PermGMod );

AUTO( ReadLocal( "c_tensorprod" ),
  TensorProductGMod, WedgeGMod );

AUTO( ReadLocal( "c_wreathprod" ),
  WreathProd, WreathPower, PowerPerm, PermDegree );

AUTO( ReadLocal( "choose" ),
  ElementOfOrder, LargestPrimeOrderElement, LargestPrimePowerOrderElement,
  ChooseRandomElements, ElementWithCharPol );

AUTO( ReadLocal( "chop" ),
  ChopGMod, Distinguish, MinSub );

AUTO( ReadLocal( "eliminate" ),
  FindExpressions, SortCFs, InvariantsOfCF, FindSolutions, TestSolution,
  TotallyDesperate, FindMinimalSubGMods, ExtractLargestPrimeOrderElement,
  SetupFactor, SetupElements, FixedPointFreeElement,
  ExtractLargestPrimePowerOrderElement, ProcessSubGMod,
  ExamineCompositionFactors, SampleOfElements, SampleOfCommutators,
  SomePowerFixesBlock, ChooseFirstElement, EliminateBlockNumber );

AUTO( ReadLocal( "extraspecial" ),
  ExtraSpecialDecomp, Stripped, InverseMod );

AUTO( ReadLocal( "gpelts" ),
  RandomElMatGp, RandomConj, AddRandomConj, AddRandomTranslatingConj,
  Commutators );

AUTO( ReadLocal( "homomorphism" ),
  IsomGMod, MatSum, HomGMod, SortHomGMod, MinSubGMods );

AUTO( ReadLocal( "matorb" ),
  HashVal, SpinSpacePerm, SpinVecPerm );

AUTO( ReadLocal( "minblocks" ),
  FilterVector, Rep, SetRep, SetImage, InverseColumn, EquateBlocks,
  CountBlocks, AmalgamateBlocks, InitialiseBlock, BlockImage, StandardVector,
  SetupBasis, SetupBlockPermGroup, MinBlocks );

AUTO( ReadLocal( "misc" ),
  PrintMat, DisplayMatrix, DegreePermGroup, FactorsToInt, IsDiagonalMatrix,
  IsScalarMatrix, MatrixProjectiveOrder, MatrixOrder );

AUTO( ReadLocal( "module" ),
  GModule, IsGModule, SetMatricesFlag, MatricesFlag, SetFieldFlag, FieldFlag,
  SetDimFlag, DimFlag, SetReducibleFlag, ReducibleFlag, UndoReducibleFlag,
  SetAbsReducibleFlag, AbsReducibleFlag, UndoAbsReducibleFlag,
  SetSemiLinearFlag, SemiLinearFlag, SetTensorProdFlag, TensorProdFlag,
  UndoTensorProdFlag, SetImprimitiveFlag, ImprimitiveFlag, SetBlockSystemFlag,
  BlockSystemFlag, SetSubbasisFlag, SubbasisFlag, SetAlgElFlag, AlgElFlag,
  SetAlgElMatFlag, AlgElMatFlag, SetAlgElCharPolFlag, AlgElCharPolFlag,
  SetAlgElCharPolFacFlag, AlgElCharPolFacFlag, SetAlgElNullspaceVecFlag,
  AlgElNullspaceVecFlag, SetAlgElNullspaceDimFlag, AlgElNullspaceDimFlag,
  SetFieldExtDegFlag, FieldExtDegFlag, UndoFieldExtDegFlag, SetCentMatFlag,
  CentMatFlag, UndoCentMatFlag, SetCentMatMinPolyFlag, CentMatMinPolyFlag,
  SetLinearPartFlag, LinearPartFlag, SetFrobeniusAutosFlag,
  FrobeniusAutosFlag, SetTensorBasisFlag, TensorBasisFlag,
  UndoTensorBasisFlag, SetTensorFactorsFlag, TensorFactorsFlag,
  UndoTensorFactorsFlag, SetSymTensorProdFlag, SymTensorProdFlag,
  SetSymTensorBasisFlag, SymTensorBasisFlag, SetSymTensorFactorsFlag,
  SymTensorFactorsFlag, SetSymTensorPermFlag, SymTensorPermFlag,
  SetExtraSpecialFlag, ExtraSpecialFlag, SetExtraSpecialPartFlag,
  ExtraSpecialPartFlag, SetExtraSpecialPrimeFlag, ExtraSpecialPrimeFlag );

AUTO( ReadLocal( "polyfactorsdeg" ),
  FactorsSquarefreePolDeg, FactorsPolDeg );

AUTO( ReadLocal( "primitive" ),
  IsBlockSystem, LengthOfBlockSystem, BlockSizes, SetBlockSizes, BlockNumbers,
  SetBlockNumbers, DeleteComponents, ConstructBlock, CheckTensorProduct,
  InverseSet, GcdSeq, LcmSeq, ExponentGL, IsValidSymOrder, GcdOrderGL,
  IsOrderValid, OrderOfElement, SetOfNullSpaces, PolynomialQuotient,
  PolynomialCoefficients, PolynomialRemainder, ZeroPolynomial,FindLargestPower, FreeRank,
  ExamineSmashGModResult, AddSmashGModQueue, IndexMinimumRankElement,
  SmashGModElement, CallSmashGMod, CharPolPrimeOrder, CharPolPrimePowerOrder,
  CharPolStructure, CompositeOrders, CoreOfSpace, FindGoodFactors,
  CommonIntersections, SemiLinearCheck, BasicReductionTests,
  FinishComputation, SettleComputation, PrimitiveTest, ReportResult,
  StartPrimitivityTest, IsPrimitiveGMod, IsPrimitiveMatrixGroup );

AUTO( ReadLocal( "random" ),
  ScrambleElements, InitialiseSeed, RandomElement );

AUTO( ReadLocal( "reducible" ),
  OrthogVec, SpinBasis, SubGMod, SubGModAction, QuotGMod, SubQuotGMod,
  IsIrredGMod, RandomIrredSubGMod, GoodElMod, EnlargeIrreducibleModule );

AUTO( ReadLocal( "semilinear" ),
  SemiLinearDecomp, PowerMaps );

AUTO( ReadLocal( "smash" ),
  SmashGMod, SemiSimpleDecomp, TranslatesDirectSum, TranslatesSModules,
  TranslatesIrreducible );

AUTO( ReadLocal( "tensorprod" ),
  TensorProductDecomp, KroneckerFactors, UndoTensorProdFlags,
  SymTensorProductDecomp, MultipleTensorProductDecomp, IntPower, SwapFactors );

