/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   Definitions, visible to others, of Boolean operation modules:	     *
*****************************************************************************/

#ifndef BOOL_LIB_H
#define BOOL_LIB_H

/* Boolean operations types: */
typedef enum {
    BOOL_OPER_OR = 1,
    BOOL_OPER_AND,
    BOOL_OPER_SUB,
    BOOL_OPER_NEG,
    BOOL_OPER_CUT,
    BOOL_OPER_MERGE
} BoolOperType;

/* Prototypes of the global routines in adjacency.c module: */
int BoolGenAdjacencies(IPObjectStruct *PObj);

/* Prototypes of global functions in bool-2d.c module: */
IPPolygonStruct *Boolean2D(IPPolygonStruct *Pl1,
			   IPPolygonStruct *Pl2,
			   BoolOperType BoolOper);

/* Prototype of the global functions in the Boolean operations module: */
IPObjectStruct *BooleanOR(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanAND(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanSUB(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanNEG(IPObjectStruct *PObj);
IPObjectStruct *BooleanCUT(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanICUT(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanMERGE(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
void BoolSetOutputInterCurve(int OutputInterCurve);
void BoolSetHandleCoplanarPoly(int HandleCoplanarPoly);
void BoolSetPolySortAxis(int PolySortAxis);
void BoolCleanUpPolygonList(IPPolygonStruct **PPolygon);

#endif /* BOOL_LIB_H */
