#include "irit_sm.h"
#include "iritprsr.h"
#include "allocate.h"
#include "geomvals.h"

void main(int argc, char **argv)
{
    int Handler;

    if (argc == 2) {
	if ((Handler = IritPrsrOpenDataFile(argv[1], TRUE, TRUE)) >= 0) {
	    IPObjectStruct
		*PObj = IritPrsrGetObjects(Handler);

	    /* Done with file - close it. */
	    IritPrsrCloseStream(Handler, TRUE);

	    /* Process the geometry - compute the accumulated area. */
	    if (IP_IS_POLY_OBJ(PObj) && IP_IS_POLYGON_OBJ(PObj))
		fprintf(stderr, "Area of polyhedra is %lf\n",
			PolyObjectArea(PObj));
	    else
	        fprintf(stderr, "Read object is not a polyhedra.\n");

	    IPFreeObject(PObj);
	}
	else {
	    fprintf(stderr, "Failed to open file \"%s\"\n", argv[1]);
	    exit(1);
	}
    }
    else {
	fprintf(stderr, "Usage: PolyArea geom.dat\n");
	exit(2);
    }

    exit(0);
}
