* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                            *  POLYCONIC  *
* **********************************************************************
      SUBROUTINE PJ07Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(2)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* **** PARAMETERS **** A,E,ES,LON0,LAT0,X0,Y0,E0,E1,E2,E3,ML0 **********
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA TOL /1.0D-7/
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS07Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      E0 = ONE
      E1 = ZERO
      E2 = ZERO
      E3 = ZERO
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 080
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
  080 E0 = E0FNZ0 (ES)
      E1 = E1FNZ0 (ES)
      E2 = E2FNZ0 (ES)
      E3 = E3FNZ0 (ES)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
      E0 = E0Z
      E1 = E1Z
      E2 = E2Z
      E3 = E3Z
  120 CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      ML0 = MLFNZ0 (E0,E1,E2,E3,LAT0)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LON0,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS(2),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ES,ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (POLYCONIC',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' LONGITUDE OF ORIGIN          =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF07Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 700
      RETURN
  220 CON = ADJLZ0 (GEOG(1) - LON0)
      IF (DABS(GEOG(2)) .GT. TOL) GO TO 240
      PROJ(1) = X0 + A * CON
      PROJ(2) = Y0 - A * ML0
      RETURN
  240 SINPHI = DSIN (GEOG(2))
      COSPHI = DCOS (GEOG(2))
      ML = MLFNZ0 (E0,E1,E2,E3,GEOG(2))
      MS = MSFNZ0 (E,SINPHI,COSPHI)
      CON = CON * SINPHI
      PROJ(1) = X0 + A * MS * DSIN (CON) / SINPHI
      PROJ(2) = Y0 + A * (ML - ML0 + MS * (ONE - DCOS (CON)) / SINPHI)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI07Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 320
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 700
      RETURN
  320 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      AL = ML0 + Y / A
      IF (DABS (AL) .GT. TOL) GO TO 340
      GEOG(1) = X / A + LON0
      GEOG(2) = ZERO
      RETURN
  340 B = AL * AL + (X / A) ** 2
      GEOG(2) = PHI4Z0 (ES,E0,E1,E2,E3,AL,B,C,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      GEOG(1) = ADJLZ0 (ASINZ0 (X * C / A) / DSIN (GEOG(2)) + LON0)
      RETURN
*
      END
