#ifndef _Piano_H
#define _Piano_H

#include <qbutton.h>
#include <qlabel.h>


class Octave;

class PianoKey : public QLabel
{
        Q_OBJECT
public:
	static const char *KeyClassName;
	PianoKey(Octave* parent, int note, bool isblack=FALSE);
	int     note() const { return _note; }
	bool isBlack() const { return _isBlack; }
protected:
	void mousePressEvent(QMouseEvent*);
	void mouseMoveEvent(QMouseEvent*);
	void mouseReleaseEvent(QMouseEvent*);
public slots:
	void KeyDown();
	void KeyUp();

signals:
	void Down(QPoint*);
	void Move(QPoint*);
	void Up(QPoint*);
private:
	const int  _note;
	const bool _isBlack;
	
};

class Octave : public QWidget
{
	Q_OBJECT
public:
	Octave(int baseNote, QWidget* parent=0, const char* name=0);
	PianoKey *key(int i);
protected:
	void resizeEvent(QResizeEvent*);

signals:
	void Down(QPoint*);
	void Move(QPoint*);
	void Up(QPoint*);
protected:
	PianoKey *keys[12];
};


class Piano : public QWidget
{
	Q_OBJECT
public: 
	Piano(int nOctave,int baseNote,QWidget* parent, const char* name=0);
protected:
	void resizeEvent(QResizeEvent*);
protected slots:
	void Down(QPoint*);
        void Down(int note);

	void Move(QPoint*);

	void Up(QPoint*);
        void Up(int note);
signals:
	void noteOn(int note);
	void noteOff(int note);

protected:
	Octave *   oct[6];
	PianoKey * currentKey;
	int       _nOctave;
	int       _baseNote;
};


#endif

