#ifndef _JContext_H
#define _JContext_H


class JComposition;
class JDurationTool;
class JFocus;
class JConductor;
class JBPT;
class JVoiceRecorder;
class JCursor;
class JMeter;
class JSequence;
class JCursor;


class JContext
{
public:
  JContext::JContext(const char *name="Song");
  ~JContext();
  
  JComposition *   composition() const { return _composition; }
  JConductor  *    conductor()   const { return _conductor; }
  JDurationTool*   duration()    const { return _duration; }
  JFocus *         focus()       const { return _focus; }
  JBPT *           left()        const { return _left; }
  JBPT *           right()       const { return _right; }
  JBPT *           time()        const { return _time; }
  JVoiceRecorder * recorder()    const { return _voiceRec; }
  JMeter *         meter()       const { return _meter; }
  JSequence *      sequence()    const { return _sequence; }
  JCursor *        cursor()      const { return _cursor; }

private:

  JComposition *   _composition;
  JConductor *     _conductor;
  JDurationTool *  _duration;
  JFocus *         _focus;
  JBPT *           _left;
  JBPT *           _right;
  JBPT *           _time;
  JVoiceRecorder * _voiceRec;
  JCursor *        _cursor;
  JMeter *         _meter;
  JSequence *      _sequence;
};



#endif
