#ifndef _JBeat_H
#define _JBeat_H

#include <math.h>

#include "assert.h"

class ostream;
class istream;
class JDuration;
class JTempo;

class JBeat
{

  friend class JDuration;

public:

  JBeat(double rep=0):_rep(rep){;}

  JBeat(int beats,int numerator,int denominator)
  {
    _rep = beats + ((double)numerator)/((double)denominator);
  }

  //  operator double() { return _rep; }

  void   quantize(long denom);

  double rep() const { return _rep; }
  inline JBeat & operator +=(const JDuration &dur);
  inline JBeat & operator -=(const JDuration &dur);    

  static const JBeat & JBeat::endOfTime() { return _endOfTime; }
  static const JBeat & JBeat::startOfTime() { return _startOfTime; }
protected:

  double _rep;
  static const double _tolerance = 1e-4;

  static const JBeat _endOfTime;
  static const JBeat _startOfTime;


  friend JDuration operator%(const JBeat &a,const JDuration &d); 
//  friend JTime operator*(const JDuration &a,const JTempo &tempo);
  ///
  friend JBeat operator+(const JBeat &a,const JDuration &b);
  ///
  friend JBeat operator-(const JBeat &a,const JDuration &b);
  ///
  friend bool operator!=(const JBeat &a,const JBeat &b);
  ///
  friend bool operator==(const JBeat &a,const JBeat &b);

  ///
  friend bool operator>=(const JBeat &a,const JBeat &b);
  ///
  friend bool operator<=(const JBeat &a,const JBeat &b);
  ///
  friend bool operator<(const JBeat &a,const JBeat &b);
  friend JDuration operator-(const JBeat &a,const JBeat &b);
  ///
  friend bool operator>(const JBeat &a,const JBeat &b);
};



class JDuration:public JBeat
{
public:

  JDuration(){;}

  //  JDuration(const JBeat &beat):JBeat(beat){;}

  JDuration(double rep):JBeat(rep){;}

  JDuration(int beats,int numerator,int denominator)
    :JBeat(beats,numerator,denominator)
  {;}
  friend JDuration operator - (const JDuration &d);
};

inline
JDuration operator - (const JDuration &d)
{
  return JDuration(-d._rep);
}


inline
JDuration operator%(const JBeat &a,const JDuration &dur)
{
  return JDuration(fmod(a._rep,dur._rep));
}

inline
JBeat &
JBeat::operator+=(const JDuration &b)
{
  _rep += b._rep;

  return *this;

}


inline
JBeat &
JBeat::operator-=(const JDuration &b)
{
  _rep -= b._rep;

  return *this;

}


inline
JBeat operator+(const JBeat &a,const JDuration &b)
{
  return JBeat(a._rep + b._rep);
}




inline
JBeat operator-(const JBeat &a,const JDuration &b)
{
  return JBeat(a._rep-b._rep);
}


inline
JDuration operator+(const JDuration &a,const JDuration &b)
{
  return JDuration(a.rep()+b.rep());
}


inline
JDuration operator-(const JDuration &a,const JDuration &b)
{
  return JDuration(a.rep()-b.rep());
}


inline
JDuration operator-(const JBeat &a,const JBeat &b)
{
  return JDuration(a._rep-b._rep);
}

inline
bool operator >= (const JBeat &a,const JBeat &b)
{
  return a._rep >= b._rep;
}

inline
bool operator <= (const JBeat &a,const JBeat &b)
{
  return a._rep <= b._rep;
}


inline
bool operator == (const JBeat &a,const JBeat &b)
{
  return (fabs(a._rep - b._rep) <= JBeat::_tolerance);
}

inline
bool operator!=(const JBeat &a,const JBeat &b)
{
  return !(a == b);
}

inline
bool operator < (const JBeat &a,const JBeat &b)
{
  return a._rep < b._rep;
}


inline
bool operator > (const JBeat &a,const JBeat &b)
{
  return a._rep > b._rep;
}

ostream & operator << (ostream &out,const JBeat &t);
istream & operator >> (istream &in,JBeat &t);

#endif














