#include <fstream.h>
#include <qfiledlg.h>

#include "QJSaveCommand.h"

#include "jam/JContext.h"
#include "command/JConductorCommand.h"
#include "jam/JComposition.h"
#include "jam/JConductor.h"
#include "jam/JFocus.h"


QJSaveCommand::QJSaveCommand(JContext *context):_context(context),
    _saveDialog(new QFileDialog(".","*.can",0,"SaveFileDialog",TRUE))
{


}

QJSaveCommand::~QJSaveCommand()
{
//  delete _saveDialog;
}

void
QJSaveCommand::execute()
{

  _saveDialog->exec();
  
  QString fname=_saveDialog->selectedFile();

  debug(" selected file is %s ",fname.data());

  if (fname.isNull()) return;

  ofstream out(fname);

  if (out.fail()) {
    debug(" Could not open file ");
    out.close();
    return;
  }

  _context->conductor()->handle(JConductorCommand::STOP);

  JComposition *comp = _context->composition();

  comp->write(out);

  out.close();
}
