//
// This was an example that demonstrated how to use menus in Qt.
//

#include <qlabel.h>
#include <qpushbt.h>        
#include <qframe.h>         
#include <qsplitter.h>
#include <qapp.h>           // qApp
#include <qlayout.h>
#include <qkeycode.h>
#include <qwhatsthis.h>

#include "QJMainWidget.h"
#include "QJExitCommand.h"
#include "QJNewTrackCommand.h"
#include "QJOpenMidiCommand.h"
#include "QJPianoCommand.h"
#include "QJSaveCommand.h"
#include "QJReadCommand.h"
#include "QJVoiceCommand.h"
#include "QJDefaultDeviceCommand.h"
#include "QJPhraseLoopWidget.h"
#include "QJScoreWidget.h"
#include "QJDurationWidget.h"
#include "QJTransportWidget.h"      // play rewind etc
#include "QJCompositionView.h"

#ifdef J_HAVE_AWELIB
#include "QJSbkLoadCommand.h"
#endif

#include "jam/JFocus.h"
#include "jam/JContext.h"


QJMainWidget::QJMainWidget(JContext *context,
			   QWidget *parent, 	
			   const char *name )
  : QMainWindow( parent, name )
{

  _menuLookup = new QDict<QPopupMenu>;

  QWidget *central= new QWidget(this);
  setCentralWidget(central);


  QBoxLayout *topLayout = new QVBoxLayout(central);


  QSplitter *splitter = new QSplitter(QSplitter::Vertical,central);

  topLayout->addWidget(splitter,2,AlignTop);


  _trackWidget = new QJCompositionView(splitter,context);

  QWhatsThis::add(_trackWidget,
		  " Left   selects track for focus \n"
		  " Middle popup menu options \n"
		  " Right  selects track/column for input focus\n"
		  "   + - [ ]  adjust the current selected input focus");


  //----------------------------------------------------------------------


  QWidget *botWidget = new QWidget(splitter);

  QBoxLayout *layout = new QVBoxLayout(botWidget);

  QJPhraseLoopWidget *pLoop = new QJPhraseLoopWidget(botWidget,context);

  QWhatsThis::add(pLoop,
		  " Left and right loop points \n"
		  " Loop count (1 is no looping)");

  layout->addWidget(pLoop);

  _scoreWidget = new QJScoreWidget(context,botWidget);
  //  _scoreWidget->setBackgroundColor(QColor(255,255,255));
  _scoreWidget->setFocusPolicy(StrongFocus);

  layout->addWidget(_scoreWidget,1);
  layout->activate();
  
  context->focus()->attach(_scoreWidget);


  //----------------------------------------------------------------------


  splitter->show();


  QBoxLayout *botLayout = new QHBoxLayout();

  //  topLayout->addStretch(1);
  topLayout->addLayout(botLayout);

  // Note duration palette
  _durationWdgt   = new QJDurationWidget(context->duration(),central);

  botLayout->addWidget(_durationWdgt,1);


  context->left()->attach(_scoreWidget);

  context->right()->attach(_scoreWidget);

  _playWidget =  new QJTransportWidget(context,central,0); 

  botLayout->addStretch(0);

  botLayout->addWidget(_playWidget,1);


  QJOpenMidiCommand *om= new QJOpenMidiCommand(context);
  plugin("File","Read midi", om);
  
  connect(om,SIGNAL(newComposition()),_trackWidget,SLOT(rebuild()));

  plugin("File","Save",
	 new QJSaveCommand(context),CTRL + Key_S);

  //

  QJReadCommand *re= new QJReadCommand(context);
  
  plugin("File","Read",
	 re,CTRL + Key_O);
  
  connect(re,SIGNAL(newComposition()),_trackWidget,SLOT(rebuild()));
  
  //
  
  plugin("File","Quit",
	 new QJExitCommand(context),CTRL + Key_Q);

  
  plugin("Structure","New Track",
	 new QJNewTrackCommand(_trackWidget), ALT + Key_T  );
  
  
  plugin("Tools","Piano",
		new QJPianoCommand(context));

  plugin("Tools","Effects",
		new QJVoiceCommand(context));
  

  plugin("Setup","Default Device",
	 new QJDefaultDeviceCommand());
  
#ifdef J_HAVE_AWELIB    
  plugin("Tools","sbk load",new QJSbkLoadCommand(),0);
#endif


  connect(_playWidget,SIGNAL(playTimeNotify(JBeat)),
	  _scoreWidget,SLOT(playTimeUpdate(JBeat)));

  topLayout->activate();
}

QJMainWidget::~QJMainWidget()
{
}


void
QJMainWidget::plugin(const char *menuName,const char *cmdName,
		     QJCommand *command,int accel)
{

  // Does this menu header exist ?

  QPopupMenu *menu = _menuLookup->find(menuName);
  
  if ( menu == 0 ) {

    // NO then insert it.
     menu = new QPopupMenu;
     menuBar()->insertItem( menuName, menu );
     _menuLookup->insert(menuName,menu);
  }

  menu->insertItem(cmdName,command,SLOT(execute()),accel);	

}




