#ifndef _QJDrawComponents_H
#define _QJDrawComponents_H

#include "rep/JNoteStyle.h"

///
class QJDraw;
class QJPixDraw;
class QJListDraw;
class QPainter;
class JDuration;

class QJDrawComponents
{

  
protected:
  
  /// Singleton class
  QJDrawComponents();

public: 

  ///
  enum Enum {
    BODY, 
    FILLEDBODY, 
    BEAMBODY,
    TAILU1, 
    TAILU2, 
    TAILU3, 
    TAILU4, 
    TAILD1, 
    TAILD2, 
    TAILD3,
    TAILD4, 
    STDSTICK,
    LADDER,
    SEMIB,
    MINIMD,
    CROTD,
    QUAVD,
    SQUAVD,
    DSQUAVD,
    HDSQUAVD,
    MINIMU,
    CROTU,
    QUAVU,
    SQUAVU,
    DSQUAVU,
    HDSQUAVU,
    RESTSEMIB,
    RESTMINIM,
    RESTCROT,
    RESTQUAV,
    RESTSQUAV,
    RESTDSQUAV,
    RESTHDSQUAV,
    SHARP,
    FLAT,
    NATURAL,
    BASS,
    TENOR,
    TREBLE,
    ALTO,
    CURSOR,
    DIMENSION
  };

  ///
  const QJDraw* component(Enum) const;

  // create 
  const QJDraw* note(const JDuration &,JNoteStyle) const;
  const QJDraw* rest(const JDuration &) const;

  int size() const { return _size; }

  int lineSpace() const { return _size/8; }

  static QJDrawComponents *the(); //PJL

protected:
  ///
  QJDraw * _components[DIMENSION];

  ///
  QPainter *_pa;

  static QJDrawComponents *_the; //PJL
  static int _size; //PJL

};


#endif






