#ifndef _MidiInfo_H
#define _MidiInfo_H

#include "MidiEvent.h"

typedef struct _MidiInfo {
	int format;
	int tracks;
	int divisions;

	/* variable data */
	int startcs, endidx;	/* start csec, end index */
	int prevcs, curcs;	/* prev/current csec */
	int updatecs, echocs;	/* timer for control update & echo back */
	int prevev, curev;	/* event counter */
	int tempo;		/* current tempo */

	/* midi data */
	int nlists;
	MidiEvent *list;

	/* other control parameters */
	int chorus, reverb;
	int chorusdepth, reverbdepth;
	int volume_base, master_volume;
	int bass_level, treble_level;
	int accept_all_off;
	int realtime_pan;
	int multi_part;
	int check_same_csec;
	int midi_mode;	/* GM=0, MT32=1, MT32(conv)=2, GS=3, XG=4, CMF=5/6 */
	int check_gs_macro;
	int check_xg_macro, xg_mapping;
	int chn_prior;
	int do_tuning;
	unsigned int drumflag;
	int track_nums;
	int volscale;
	int skip_blank_head;
	int chn_volflag;
	int base_offset; /* in semitones */
	int parse_title;
	int seq_buffered, use_echoback;
	int use_fx;
	int fx_sense[FX_NUMS];
	
	char *filename;
	char *dynamicload;
	char *xgload;
	int sample_cleared;
	int dynamic_loaded;
} MidiInfo;


extern MidiInfo gl_default;

void copy_midi_info(MidiInfo *dst, MidiInfo *src, char *fname);

#endif
