#ifndef _JBPT_H
#define _JBPT_H

#include "JBeat.h"
#include "JOSTemplate.h"

class JBPT:public JObserver<const JToBPT *,void>,
	   public JSubject<const JBPT *,void>
{
public:
  JBPT(const JToBPT *toBPT);

  //! If my reference frame changes
  void handle(const JToBPT *);

  void addTicks(int ticks);
  void addPulses(int pulses);
  void addBars(int bars);

  void setTick(int ticks);
  void setPulse(int pulses);
  void setBar(int bars);

  void setBeat(JBeat beat);

  int bar() const        { return  _bar; }
  int beat() const       { return  _pulse; }
  int tick() const       { return  _tick; }

  int    beatsInBar() const;
  int    ticksInBeat() const;
  JBeat  time() const;

private:

  JToBPT * _toBPT;
  int      _bar;
  int      _pulse;
  int      _tick;
  JBeat    _beat;

};


#endif
