#include <stdio.h>
#include <stdarg.h>

#include "rep/JMidiDefines.h"


#include "JTimer.h"   //TODO: sort out the tempo track
#include "JMidiFileReader.h"
#include "MidiEvent.h"
#include "JComposition.h"
#include "JTrack.h"
#include "JVoice.h"
#include "JPart.h"
#include "JPhrase.h"
#include "JEventPhraseBuilder.h"
#include "JVoiceManager.h"
#include "controls.h"
#include "JMapper.h"
#include "JTrackList.h"

#ifndef CTL_REVERB_DEPTH
#define CTL_REVERB_DEPTH CTL_EXT_EFF_DEPTH
#endif

#define numberof(ary)	(sizeof(ary)/sizeof(ary[0]))

#if 0
static struct control_label {
	int type;
	char *str;
} labels[] = {
	{CTL_MODWHEEL, "modwheel"},
	{CTL_MAIN_VOLUME, "main_volume"},
	{CTL_PAN, "pan"},
	{CTL_EXPRESSION, "expression"},
	{CTL_SUSTAIN, "sustain"},
	{CTL_SOSTENUTO, "sostenuto"},
	{CTL_CHORUS_DEPTH, "chorus"},
	{CTL_REVERB_DEPTH, "reverb"},
}, names[] = {
	{CTL_SOFT_PEDAL, "soft_pedal"},
	{CTL_PORTAMENTO, "portament"},
	{70, "xg_variation"},
	{71, "xg_cutoff"},
	{72, "xg_release"},
	{73, "xg_attack"},
	{74, "xg_brightness"},
};

#endif

static int cmsg(int type, int verbosity_level, char *fmt, ...);

static ControlMode dummy_ctl = 
{
  "dumb interface", 'd',
  false,
  false,
  false,
  0,0,0,0,
  NULL,NULL,NULL,NULL,NULL,cmsg,
  NULL,NULL,NULL,NULL,NULL,NULL,
  NULL,NULL,NULL,NULL,NULL,
  NULL,NULL,NULL,
};

ControlMode *ctl = &dummy_ctl;


static int cmsg(int /* type */, int verbosity_level, char *fmt, ...)
{
	va_list ap;
	if (ctl->verbosity <= verbosity_level) return 0;
	va_start(ap, fmt);
	vprintf(fmt, ap);
	printf("\n");
	va_end(ap);
	return 0;
}

// static void PrintControl(MidiEvent *e)
// {
// 	int i;
// 	for (i = 0; i < (int)numberof(labels); i++) {
// 		if (labels[i].type == CtrlOf(e)) {
// 			printf("%-16s (%02d) %d %d\n", labels[i].str,
// 			       e->channel, CtrlOf(e), CValOf(e));
// 			 return;
// 		 }
// 	 }
// 	 for (i = 0; i < (int)numberof(names); i++) {
// 		 if (names[i].type == CtrlOf(e)) {
// 			 printf("%-16s (%02d) %d %d %s\n", "control",
// 				e->channel, CtrlOf(e), CValOf(e),
// 				names[i].str);
// 			 return;
// 		 }
// 	 }
// 	 printf("%-16s (%02d) %d %d\n", "control",
// 		e->channel, CtrlOf(e), CValOf(e));
//  }




 static void PrintCD(char *msg, MidiEvent *e)
 {
	 printf("%-16s (%02d) %d %d\n", msg, e->channel, KeyOf(e), VelOf(e));
 }

 static void PrintCB(char *msg, MidiEvent *e)
 {
	 printf("%-16s (%02d) %d\n", msg, e->channel, e->p.val);
 }


 JMidiFileReader::JMidiFileReader(JComposition *comp,const char *filename)
   :JMidiFileProcessor(filename),_comp(comp),_tempo(120.0)
 {
   for (int i=0;i<MAX_TRACKS; i++) {
     _track[i]=0;
     _phrase[i]=0;
     _builder[i]=0;
   }
     _part=0;

 }


void
JMidiFileReader::initialize()
{
   _comp->trackList()->clear(true);
}

bool
JMidiFileReader::processEvent(const MidiEvent *eventConst)
{
  MidiEvent *event=(MidiEvent *)eventConst;

  int channel=event->channel;

  if (_part == 0) 
    _part = new JPart(_comp);

  assert(channel >= 0 && channel < MAX_TRACKS);

  if (_track[channel] == 0 ) {
    JVoice * voice;  
    //TODO clean up the mappers ???
    if (!isDrumChannel(channel)) {
      voice   = JVoiceManager::the()->newVoice("VOICE");
      voice->setChannelId(channel);
    } else {
      voice   = JVoiceManager::the()->newVoice("DRUM");
      voice->setChannelId(channel);
    }

    _track[channel]  = _comp->newTrack(voice);
    _phrase[channel] = _track[channel]->newPhrase(_part);
    _builder[channel]= new JEventPhraseBuilder(_phrase[channel]);
  }	

  JEventPhraseBuilder *builder=_builder[channel];

#if 0
  if (ChannelEvents(event.type)) {
    if (output_flags &&
	!(output_flags & DRUMBIT(event.channel)))
      continue;
  }
#endif

  //  printf("%-15d %-15d \n", event->csec, event->time);


  JBeat b(0,event->time,120);

  if (b.rep() <= 0.0) b=JBeat(0.00001);

  //  JPhraseEvent *phraseEvent=0;

  int index=0;
  int val=0;
  JMidiOutType type;

  switch (event->type) {
  case ME_NOTEON:
    if (VelOf(event) != 0) {
      index= KeyOf(event);
      val  = VelOf(event); 
      type = JMidiOutType::NOTE_EFFECT;
      break;
    }

  case ME_NOTEOFF:
    index= KeyOf(event);
    val  = 0;
    type = JMidiOutType::NOTE_EFFECT;
    break;

  case ME_KEYPRESSURE:
    //    type = 
    PrintCD("key_press", event ); 
    return true;
    break;

  case ME_CHNPRESSURE:
    type = JMidiOutType::CHNPRESSURE_EFFECT;
    index= 0;
    val  = CValOf(event);
    break;

  PrintCB("chn_press", event );
    return true;
    break;

  case ME_PITCH_SENS:
    PrintCB("pitch_sens", event ); 
    return true;
    break;

  case ME_PITCHWHEEL:
    type=JMidiOutType::PITCHBEND_EFFECT;
    index=0;
    val=event->p.val;
    break;

  case ME_CONTROL:
    type=JMidiOutType::CNTRL_EFFECT;
    index=CtrlOf(event);
    val=CValOf(event);
    break;

  case ME_PROGRAM:
    type=JMidiOutType::PROGRAM_EFFECT;
    index=0;
    val=CtrlOf(event);
    break;

  case ME_RESET_CONTROLLERS:
    PrintCB("reset_control", event );
    return true;
    break;

  case ME_ALL_NOTES_OFF:
    type=JMidiOutType::ALLNOTEOFF_EFFECT;
    index=0;
    val=0;
    break;

  case ME_ALL_SOUNDS_OFF:
    printf("all_sounds_off \n"); 
    return true;
    break;

  case ME_TONE_BANK:
    PrintCD("tone_bank", event ); 
    return true;
    break;

  case ME_TEMPO:
    _tempo = 60000000.0/(double)(event->p.val);
    printf("%-16s %f\n", "tempo", _tempo);
    JTimer::the()->setTempo(_tempo);
    return true;
    break;

  case ME_LYRIC:
    printf("%-16s\n", "lyric");
    return true;
    break;

  case ME_MASTER_VOLUME:
    type=JMidiOutType::CNTRL_EFFECT;
    index=ME_MASTER_VOLUME;
    val=CtrlOf(event);
    break;

  case ME_AWE_FX:
    // NRPNEvent(event );
     return true;
    break;

  case ME_GS_FX:
    //     printf("%-16s (%02d) %d %d", "gs_nrpn",
    // 	   event->channel, event->p.par[0], event->p.par[1]);
    //     {int p;
    //     for (p = 0; p < num_gs_effects; p++) {
    //       if (gs_effects[p].control == event->p.par[0]) {
    // 	printf(" %s", gs_effects[p].name);
    // 	break;
    //       }
    //     }
    //     }
    //     printf("\n");
    /*PrintCD("gs_nrpn", event );*/
    return true;
    break;

  case ME_FINETUNE:
    PrintCB("fine_tune", event );
    return true;
    break;

  case ME_COARSETUNE:
    PrintCB("coarse_tune", event );
    return true;
    break;
    
  case ME_EOT:
    printf("end_of_tune \n");
    return false;
    exit(0);
  }

  builder->appendEventAt(b,type,index,val);

  return true;
}



