
#include "JDLL.h"
#include "assert.h"

void
JDLListBase::discardHead()
{

  JDLLNode *temp=_first;

  assert(temp!=0);

  _first=_first->_next;

  if ( _first != 0 ) _first->_prev=0;

  //  DLLNodeFactory::the()->recycle(temp);
  delete temp;
}

void
JDLListBase::_addToEnd(void *ptr)
{

  if (_first == 0) {
    _first=_last=new JDLLNode(ptr,0,0);  
  }  else  {
    assert( _last != 0 );
    _last->_next=new JDLLNode(ptr,_last,0);
    _last=_last->_next;
  }
}


bool
JDLListBase::_contains(void *findme) const
{

  if (_first == 0) return false;
  
  JDLLNode *node=_first;

  do
    {
      if (node->_ptr == findme) return true;
    }
  while( (node=node->_next) != 0 );

  return false;

}


int
JDLListBase::_find(const void *findme) const 
{

  
  if (_first == 0) return -1;
  
  JDLLNode *node=_first;

  int num=0;

  do {
    if (node->_ptr == findme) return num;
    num++;
  }
  while( (node=node->_next) != 0 );

  return -1;

}


int
JDLListBase::count() const
{

  int count=0;
  JDLLNode *node=_first;

  while (node != 0) {
    count++;
    node=node->_next;
  }

  return count;

}

void *
JDLListBase::_at(int count) 
{


  JDLLNode *node=_first;

  
  while (node != 0) {
    if (count == 0) return node->_ptr;
    count--;
    node=node->_next;
  }

  return 0;

}


void
JDLListBase::_addToStart(void *ptr)
{

  if (_first == 0)
    {
      _first=_last=new JDLLNode(ptr,0,0);  
    }
  else
    {
      assert( _last != 0 );
      _first->_prev=new JDLLNode(ptr,0,_first);
      _first=_first->_prev;
    }
}



void
JDLListBase::_insertBefore(JDLLNode *node,void *ptr)
{
  assert(   ptr != 0 );
  assert(  node != 0 );
  assert( _last != 0 );

  JDLLNode *newNode=new JDLLNode(ptr,node->_prev,node);

  if (node->_prev != 0) 
    {
      node->_prev->_next=newNode;
    }

  node->_prev       =newNode;

  if (node == _first) _first=newNode;

}






