#include <iostream.h>
#include "random.h"
#include "phradptr.h"
#include "phrase.h"
#include "beatblk.h"
#include "flowanal.h"
#include "flowblk.h"
#include "iterator.h"
#include "note.h"
#include "noteblk.h"
#include "phradptr.h"
#include "phrase.h"
#include "randcont.h"
#include "rcorblk.h"
#include "rhytmblk.h"
#include "rhytmcor.h"
#include "scaleanl.h"
#include "phrasnfo.h"

// Default constructor
phrase_adapter_c::phrase_adapter_c(){
  phrase_ptr = NULL;
  original_phrase_ptr = NULL;
  corr_ptr = NULL;
  scale_ptr = NULL;
  flow_ptr = NULL;
  randomc_ptr = NULL;
}

// Default constructor
phrase_adapter_c::phrase_adapter_c(double tempo_d, int beats_in_bar_i,
						  int beat_type_i, int beat_i, int numerator_i,
						  int denominator_i, int note_i, double length_d,
						  int velocity_i){
  char d;

  phrase_ptr = new phrase_c(tempo_d,  beats_in_bar_i,
				 beat_type_i, beat_i, numerator_i, denominator_i,
				 note_i, length_d, velocity_i);

  if(phrase_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  original_phrase_ptr = new phrase_c(tempo_d, beats_in_bar_i,
					  beat_type_i, beat_i, numerator_i,
					  denominator_i, note_i, length_d,
					  velocity_i);

  if(original_phrase_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }

  create_sub_systems();
}

void phrase_adapter_c::add_note(int beat_i, int numerator_i, int denominator_i,
										  int note_i, double length_d , int velocity_i){

  phrase_ptr->add_note(beat_i, numerator_i, denominator_i, note_i, length_d,
							  velocity_i);
  original_phrase_ptr->add_note(beat_i, numerator_i, denominator_i, note_i,
										  length_d, velocity_i);
  original_phrase_ptr->update_phrase_info();
  phrase_ptr->update_phrase_info();
}

void phrase_adapter_c::remove_all(){
  if(corr_ptr != NULL){
	 corr_ptr->remove_all();
	 delete corr_ptr;
  }
  if(scale_ptr != NULL){
	 scale_ptr->remove_all();
	 delete scale_ptr;
  }
  if(flow_ptr != NULL){
	 flow_ptr->remove_all();
	 delete flow_ptr;
  }
  if(randomc_ptr != NULL)
	 delete randomc_ptr;

  if(phrase_ptr != NULL){
	 phrase_ptr->remove_all();
	 delete phrase_ptr;
  }
  if(original_phrase_ptr != NULL){
	 original_phrase_ptr->remove_all();
	 delete original_phrase_ptr;
  }
}

void phrase_adapter_c::process_phrase(){
  int a;
  int random_i;
  int process_values_i[10];
  int process_array_i[10] = {0,0,0,0,0,0,0,0,0,0};
  int process_i;
  int no_different_processes_i;
  int no_process_loops_i;
  char d;

  scale_ptr->scale_analyse();

  cout << "\nProcesing phrase....\n\n";

  for(a = 0; a < no_process_loops_int; a++){
	 process_values_i[0] = note_changes_in_loop_int;
	 process_values_i[1] = corr_shuffles_in_loop_int;
	 process_values_i[2] = corr_increases_in_loop_int;
	 process_values_i[3] = corr_decreases_in_loop_int;
	 process_values_i[4] = intro_notes_in_loop_int;
	 process_values_i[5] = intro_corr_notes_in_loop_int;
	 process_values_i[6] = elim_notes_in_loop_int;
	 process_values_i[7] = elim_block_in_loop_int;
	 process_values_i[8] = elim_corr_notes_in_loop_int;
	 process_values_i[9] = elim_corr_block_in_loop_int;
	 do{
		process_i = 0;

		for(a = 0; a < 10; a++){
		  if(process_values_i[a] > 0){
			 process_array_i[process_i] = a;
			 process_i++;
		  }
		}
		if(process_i > 0){
		  random_i = RANDOM(process_i);
		  process_values_i[process_array_i[random_i]]--;
		  call_function(process_array_i[random_i],
							 process_values_i[process_array_i[random_i]]);
		}
	 }while(process_i > 0);
  }
  cout << "\nCompleted processing.\n";
  //  phrase_ptr->display_phrase();
}

void phrase_adapter_c::call_function(int function_i, int num_i){
  switch(function_i){
	 case 0: change_note(1); // Changes time block of notes //
				if(num_i == 0)
				  cout << "completed note changes." << endl;
				break;
	 case 1: change_corr(0); // Shuffle exiting correlation //
				if(num_i == 0)
				  cout << "completed rhythm shuffles." << endl;
				break;
	 case 2: change_corr(1); // Increase correlation //
				if(num_i == 0)
				  cout << "completed correlation increases." << endl;
				break;
	 case 3: change_corr(3);  // Decrease correlation //
				if(num_i == 0)
				  cout << "completed correlation decreases." << endl;
				break;
	 case 4: change_corr(4); // Add note to random location //
				if(num_i == 0)
				  cout << "completed note introductions." << endl;
				break;
	 case 5: change_corr(2);  // Add note using correlation //
				if(num_i == 0)
				  cout << "completed correlated note introductions" << endl;
				break;
	 case 6: eliminate(0);  // Eliminate a single note //
				if(num_i == 0)
				  cout << "completed note eliminations" << endl;
				break;
	 case 7: eliminate(1); // Eliminate a block of notes //
				if(num_i == 0)
				  cout << "completed block eliminations" << endl;
				break;
	 case 8: eliminate(2);  // Eliminate a single correlated note //
				if(num_i == 0)
				  cout << "completed correlated note eliminations" << endl;
				break;
	 case 9: eliminate(3); // Eliminate a correlated block of notes //
				if(num_i == 0)
				  cout << "completed correlated block eliminations" << endl;
				break;
  }
}

void phrase_adapter_c::setup_read(){
  phrase_ptr->iterator()->set_iterator(phrase_ptr->phrase(),
													phrase_ptr->phrase());
  original_phrase_ptr->iterator()->set_iterator(original_phrase_ptr->phrase(),
																original_phrase_ptr->phrase());
}

void phrase_adapter_c::get_info(int new_i, phrase_info_c *phrase_info_p){
  if(new_i == 1){
	 phrase_info_p->tempo_int = (int)phrase_ptr->tempo();
	 phrase_info_p->beats_in_bar_int = phrase_ptr->beats_in_bar();
	 phrase_info_p->beat_type_int = phrase_ptr->beat_type();
  }else{
	 phrase_info_p->tempo_int = (int)original_phrase_ptr->tempo();
	 phrase_info_p->beats_in_bar_int = original_phrase_ptr->beats_in_bar();
	 phrase_info_p->beat_type_int = original_phrase_ptr->beat_type();
  }
}

int phrase_adapter_c::get_note(int new_i, note_info_c *note_info_p){
  int at_end_i = 0;

  if(new_i == 1){
	 note_info_p->beat_int = phrase_ptr->iterator()->rhythm_block()->beat();
	 note_info_p->numerator_int = phrase_ptr->iterator()->rhythm_block()->
									 numerator();
	 note_info_p->denominator_int = phrase_ptr->iterator()->rhythm_block()->
									 denominator();
	 note_info_p->note_int = phrase_ptr->iterator()->note_pntr()->note();
	 note_info_p->length_dbl = phrase_ptr->iterator()->note_pntr()->length();
	 note_info_p->velocity_int = phrase_ptr->iterator()->note_pntr()->velocity();
	 phrase_ptr->iterator()->iterate(0, 0);

	 if(phrase_ptr->iterator()->rhythm_block() == phrase_ptr->phrase())
		at_end_i = 1;
  }else{
	 note_info_p->beat_int = original_phrase_ptr->iterator()->rhythm_block()->
									 beat();
	 note_info_p->numerator_int = original_phrase_ptr->iterator()->
									 rhythm_block()->numerator();
	 note_info_p->denominator_int = original_phrase_ptr->iterator()->
									 rhythm_block()->denominator();
	 note_info_p->note_int = original_phrase_ptr->iterator()->note_pntr()->
									 note();
	 note_info_p->length_dbl = original_phrase_ptr->iterator()->note_pntr()->
									 length();
	 note_info_p->velocity_int = original_phrase_ptr->iterator()->note_pntr()->
									 velocity();
	 original_phrase_ptr->iterator()->iterate(0, 0);

	 if(original_phrase_ptr->iterator()->rhythm_block()
		 == original_phrase_ptr->phrase())
		at_end_i = 1;
  }
  return at_end_i;
}

void phrase_adapter_c::set_variables(int *values_i){
  allow_scale_morph_int = values_i[0];
  morph_limit_int = values_i[1];
  adjust_scale_variation_int = values_i[2];
  svlow_int = values_i[3];
  svmidl_int = values_i[4];
  svmidh_int = values_i[5];
  svhigh_int = values_i[6];
  fix_start_note_location_int = values_i[7];
  fix_start_note_pitch_int = values_i[8];
  allow_phrase_growth_int = values_i[9];
  growth_fraction_array_ptr[0] = values_i[10];
  growth_fraction_array_ptr[1] = values_i[11];
  growth_fraction_array_ptr[2] = values_i[12];
  phrase_ptr->minimise_fraction(growth_fraction_array_ptr);
  no_process_loops_int = values_i[13];
  note_changes_in_loop_int = values_i[14];
  corr_shuffles_in_loop_int = values_i[15];
  corr_increases_in_loop_int = values_i[16];
  corr_decreases_in_loop_int = values_i[17];
  intro_notes_in_loop_int = values_i[18];
  intro_corr_notes_in_loop_int = values_i[19];
  elim_notes_in_loop_int = values_i[20];
  elim_block_in_loop_int = values_i[21];
  elim_corr_notes_in_loop_int = values_i[22];
  elim_corr_block_in_loop_int = values_i[23];
  rclow_int = values_i[24];
  rcmidl_int = values_i[25];
  rcmidh_int = values_i[26];
  rchigh_int = values_i[27];
  smaller_fraction_value_int = values_i[28];
  fslow_int = values_i[29];
  fsmidl_int = values_i[30];
  fsmidh_int = values_i[31];
  fshigh_int = values_i[32];

  morph_count_int = 0;

  if(svlow_int == 0)
	 svlow_int = 1;
  if(svmidl_int == 0)
	 svmidl_int = 1;
  if(svmidh_int == 0)
	 svmidh_int = 1;
  if(svhigh_int == 0)
	 svhigh_int = 1;

  if(rclow_int == 0)
	 rclow_int = 1;
  if(rcmidl_int == 0)
	 rcmidl_int = 1;
  if(rcmidh_int == 0)
	 rcmidh_int = 1;
  if(rchigh_int == 0)
	 rchigh_int = 1;

  if(allow_scale_morph_int == 1)
	 cout << "Scale Morph enabled        -ENABLED- " << endl;
  else
	 cout << "Scale Morph disabled       -DISABLED- " << endl;
  if(fix_start_note_location_int == 1)
	 cout << "Fix Start Note Location    -ENABLED- " << endl;
  else
	 cout << "Fix Start Note Location    -DISABLED- " << endl;
  if(fix_start_note_pitch_int == 1)
	 cout << "Fix Start Note Pitch       -ENABLED- " << endl;
  else
	 cout << "Fix Start Note Pitch       -DISABLED- " << endl;
  if(adjust_scale_variation_int == 1)
	 cout << "Adjust Scale Variation     -ENABLED- " << endl;
  else
	 cout << "Adjust Scale Variation     -DISABLED- " << endl;
  if(allow_phrase_growth_int == 1)
	 cout << "Allow Length Increase      -ENABLED- " << endl;
  else
	 cout << "Allow Length Increase      -DISABLED- " << endl;
}

void phrase_adapter_c::create_sub_systems(){
  char d;

  corr_ptr = new rhythm_correlate_c(phrase_ptr);
  if(corr_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  scale_ptr = new scale_analyse_c(phrase_ptr);
  if(scale_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  flow_ptr = new flow_analyse_c(phrase_ptr);
  if(flow_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  randomc_ptr = new random_control_c();
  if(randomc_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
}

// Location: 0 existing, 1 non-existing, 2 corr/match gap and it's pair, //
//           3 match beat array, 4 flow group                            //
void phrase_adapter_c::select_location(int location_type){
  int fix_start_i = fix_start_note_pitch_int;
  int a;
  int number_i;
  int random_i;
  int tmp_i;
  int exit_i = 0;
  int loop_i = 0;
  rhythm_corr_block_c *current_corr_blk_p;
  rhythm_corr_block_c *tmp_p;
  int tmp_array_p[3];
        char d;
  phrase_ptr->update_phrase_info();

  if(location_type == 0){
	 phrase_ptr->iterator()->set_iterator(phrase_ptr->phrase(),
													  phrase_ptr->phrase());
	 if(phrase_ptr->phrase()->rRlink()->rRlink() == phrase_ptr->phrase())
		 fix_start_i = 0;
	 do{
		random_i = RANDOM(phrase_ptr->no_beat_blocks());

		for(a = 0;a < random_i; a++)
		  phrase_ptr->iterator()->iterate(0, 1);

		fraction1_array_ptr = phrase_ptr->iterator()->rhythm_block()->array();
	 }while((phrase_ptr->compare_fractions(fraction1_array_ptr, phrase_ptr->
			phrase()->array()) == 1)&&(fix_start_i == 1));
  }else if(location_type == 1){
	 do{
		random_i = RANDOM(phrase_ptr->phrase()->rLlink()->beat());
		random_i++; // put in correct range //

		// Set beat //
		fraction_array_ptr[0] = random_i;

		if((original_phrase_ptr->fraction()%2 == 0)
                  ||(original_phrase_ptr->fraction() == 1)){

		  tmp_i = original_phrase_ptr->fraction();
		  number_i = 1;

		  while(tmp_i%2 == 0){
			 tmp_i = tmp_i/2;
			 number_i++;
		  }
		  // allows fractions to be a power of 2 greater than original //
		  random_i = randomc_ptr->random_num(number_i +
						 smaller_fraction_value_int,fslow_int,
						 fsmidl_int,fsmidh_int,fshigh_int);

		  // Set denominator //
		  switch(random_i){
			 case 2:  fraction_array_ptr[2] = 2;
						 break;
			 case 3:  fraction_array_ptr[2] = 4;
						 break;
			 case 4:  fraction_array_ptr[2] = 8;
						 break;
			 case 5:  fraction_array_ptr[2] = 16;
						 break;
			 default: fraction_array_ptr[2] = 0;
						 break;
		  }
		  number_i = 1;
		  tmp_i = fraction_array_ptr[2];

		  if(tmp_i > 0){
			 while(tmp_i%2 == 0){
				tmp_i = tmp_i/2;
				number_i++;
			 }

			 random_i = RANDOM(number_i);

			 // Set numerator //
			 switch(random_i){
				case 2:  fraction_array_ptr[1] =
										(fraction_array_ptr[2]/4) * RANDOM(4);
							break;
				case 3:  fraction_array_ptr[1] =
										(fraction_array_ptr[2]/8) * RANDOM(8);
							break;
				case 4:  fraction_array_ptr[1] =
										(fraction_array_ptr[2]/16) * RANDOM(16);
							break;
				default: fraction_array_ptr[1] =
										(fraction_array_ptr[2]/2) * RANDOM(2);
							break;
			 }
		  }
		}else if(original_phrase_ptr->fraction()%3 == 0){
		  tmp_i = original_phrase_ptr->fraction();
		  number_i = 1;

		  while(tmp_i%3 == 0){
			 tmp_i = tmp_i/3;
			 number_i++;
		  }

		  // allows fractions to be a power of 3 greater than original //
		  random_i = randomc_ptr->random_num(number_i +
						 smaller_fraction_value_int,fslow_int,
						 fsmidl_int,fsmidh_int,fshigh_int);

		  // Set denominator //
		  switch(random_i){
			 case 2:  fraction_array_ptr[2] = 3;
						 break;
			 case 3:  fraction_array_ptr[2] = 6;
						 break;
			 case 4:  fraction_array_ptr[2] = 12;
						 break;
			 default: fraction_array_ptr[2] = 0;
						 break;
		  }

		  number_i = 1;
		  tmp_i = fraction_array_ptr[2];

		  if(tmp_i > 0){
			 while(tmp_i%3 == 0){
				tmp_i = tmp_i/3;
				number_i++;
			 }

			 // changes probability of off beat fractions //
			 random_i = RANDOM(number_i);

			 // Set numerator //
			 switch(random_i){
				case 2:  fraction_array_ptr[1] =
														(fraction_array_ptr[2]/6) * RANDOM(6);
							break;
				case 3:  fraction_array_ptr[1] =
													 (fraction_array_ptr[2]/12) * RANDOM(12);
							break;
				default: fraction_array_ptr[1] =
														(fraction_array_ptr[2]/3) * RANDOM(3);
							break;
			 }
		  }
		}else
		  fraction_array_ptr[2] = 0;

		phrase_ptr->minimise_fraction(fraction_array_ptr);
		loop_i++;
	     
		cout << "beat gen " << fraction_array_ptr[0] << "," 
                     << fraction_array_ptr[1] << "/" 
                     << fraction_array_ptr[2] << endl; 

         }while((phrase_ptr->find_rhythm_block(fraction_array_ptr) == 1)
				&&(loop_i < 20));

         cout << "final beat gen " << fraction_array_ptr[0] << "," 
              << fraction_array_ptr[1] << "/"
              << fraction_array_ptr[2] << endl;

	 if(loop_i >= 20)
		fraction_array_ptr[2] = 0;

  }else if((location_type == 2)||(location_type == 3)){
	 if(corr_ptr->corr_list() != NULL){
		current_corr_blk_p = corr_ptr->corr_list();

		random_i = randomc_ptr->random_num(corr_ptr->no_blocks(),
					  rclow_int,rcmidl_int,rcmidh_int,rchigh_int);
		for(a = 1; a < random_i; a++)
		  current_corr_blk_p = current_corr_blk_p->Rlink();

		a = 0;
		tmp_p = current_corr_blk_p;

		if(location_type == 2){
		  do{
			 random_i = randomc_ptr->random_num(2,50,50,1,1);

			 switch(random_i){
				case 1:  if(current_corr_blk_p->main_gaps() > 0)
							exit_i = 1;
							break;
				case 2:  if(current_corr_blk_p->comp_gaps() > 0)
							exit_i = 1;
							break;
			 }
			 if(exit_i == 0)
				current_corr_blk_p = current_corr_blk_p->Rlink();
			 if(current_corr_blk_p == tmp_p){
				if(a == 4)
				  exit_i = 1;
				else
				  a++;
			 }
		  }while(exit_i == 0);

		  if(a != 4){
			 if(random_i == 1){
				// Find from main gaps //
				random_i = RANDOM(current_corr_blk_p->main_gaps());

				// This sets a main gap location //
				fraction2_array_ptr = current_corr_blk_p->main_gap_array()
											 [random_i].array();
				// This sets the main gap pair, i.e. where a note is //
				phrase_ptr->add_fractions(fraction2_array_ptr,
											 current_corr_blk_p->total_shift()->array(),
											 tmp_array_p, 0);
				phrase_ptr->find_rhythm_block(tmp_array_p);
				fraction1_array_ptr = phrase_ptr->iterator()->rhythm_block()->array();
			 }else if(random_i == 2){
				// Find from comp gaps //
				random_i = RANDOM(current_corr_blk_p->comp_gaps());

				// This sets a comparison gap location //
				fraction2_array_ptr = current_corr_blk_p->comp_gap_array()
											 [random_i].array();

				// This sets the comparison gap pair, i.e. where a note is //
				phrase_ptr->add_fractions(fraction2_array_ptr,
											 current_corr_blk_p->total_shift()->array(),
											 tmp_array_p, 1);
				phrase_ptr->find_rhythm_block(tmp_array_p);
				fraction1_array_ptr = phrase_ptr->iterator()->rhythm_block()->array();
			 }
		  }else{
			 fraction1_array_ptr = 0;
		  }
		}else{
		  // Find from matches //
		  do{
			 if(current_corr_blk_p->main_matches() > 0)
				exit_i = 1;
			 else
				current_corr_blk_p = current_corr_blk_p->Rlink();
		  }while((exit_i == 0)&&(tmp_p != current_corr_blk_p));

		  if(exit_i == 1){
			 random_i = RANDOM(current_corr_blk_p->main_matches());

			 fraction1_array_ptr = current_corr_blk_p->
										  main_match_array()[random_i].array();
			 random_i = RANDOM(2);

			 if(random_i == 1){
				phrase_ptr->add_fractions(fraction1_array_ptr, current_corr_blk_p->
								total_shift()->array(), tmp_array_p, 0);
				phrase_ptr->find_rhythm_block(tmp_array_p);
				fraction1_array_ptr = phrase_ptr->iterator()->
											 rhythm_block()->array();
			 }
		  }else{
			 fraction1_array_ptr = 0;
		  }
		}
	 }else
      fraction1_array_ptr = 0;
  }else if(location_type == 4){
	 random_i = RANDOM(flow_ptr->no_blocks());

	 flow_block_ptr = &(flow_ptr->flow_array()[random_i]);
  }
  /*
  cout << "Beat 0 generated: " << fraction_array_ptr[0] << ", "
		 << fraction_array_ptr[1] << "/" << fraction_array_ptr[2] << endl;
  cout << "Beat 1 generated: " << selected_beat_ptr[0] << ", "
		 << selected_beat_ptr[1] << "/" << selected_beat_ptr[2] << endl;
  cin.get(d);
  */
}

void phrase_adapter_c::change_note(int own_location_i){
  int upper_notes_i[4];
  int lower_notes_i[4];
  int avoid_notes_i[6] = {-1,-1,-1,-1,-1,-1};
  int location_array_i[3];
  int avoid_element_i = 0;
  int random_i;
  int random2_i;
  int interval_i;
  int alter_balance_i = 0;
  int a = 0;
  rhythm_block_c *tmp_p;
  note_c **note_p;
  int note_array_size_i;
  int scale_i;
  int scale_type_i;
  int stored_i;

  flow_ptr->flow_analyse();
  scale_i = scale_ptr->main_scale()[0];
  scale_type_i = scale_ptr->main_scale()[1];

  if(((morph_limit_int == 0)&&(allow_scale_morph_int == 1))
	  ||(morph_count_int < morph_limit_int))
	 scale_ptr->scale_analyse();

  if((scale_ptr->main_scale()[0] != scale_i)
	  ||(scale_ptr->main_scale()[1] != scale_type_i))
	 morph_count_int++;

  if(own_location_i == 1)
	 select_location(0);

  location_array_i[0] = fraction1_array_ptr[0];
  location_array_i[1] = fraction1_array_ptr[1];
  location_array_i[2] = fraction1_array_ptr[2];

  if(adjust_scale_variation_int == 1)
	 random_i = randomc_ptr->random_num(6,svlow_int,svmidl_int,
													svmidh_int,svhigh_int);
  else
	 random_i = 0;
 
  scale_ptr->find_base_chord(flow_ptr, fraction1_array_ptr, NULL, random_i);
  phrase_ptr->find_rhythm_block(fraction1_array_ptr);

  tmp_p = phrase_ptr->iterator()->rhythm_block();
  note_array_size_i = tmp_p->no_notes() + 1;
  note_p = new note_c*[note_array_size_i];

  interval_i = tmp_p->note_pntr()->note() - tmp_p->rRlink()->Llink()->
														  note_pntr()->note();
  do{
	 find_notes(upper_notes_i, lower_notes_i, avoid_notes_i);
	 random_i = RANDOM(2);

	 if((random_i == 0)&&(avoid_element_i < 6)){
		avoid_notes_i[avoid_element_i] = phrase_ptr->iterator()->
													note_pntr()->note();
		avoid_element_i++;
	 }
	 random2_i = RANDOM(2);
	 if((interval_i > 5)&&(phrase_ptr->iterator()->no_notes()
		 == note_array_size_i - 1)&&(random2_i == 0)){
		phrase_ptr->iterator()->note_pntr()->adjust_pitch(-12);
		alter_balance_i = 1;
	 }else if((interval_i > 5)&&(phrase_ptr->iterator()->no_notes() == 0)
		 &&(random2_i == 0)&&(alter_balance_i == 0))
		phrase_ptr->iterator()->note_pntr()->adjust_pitch(+12);

	 note_p[a] = phrase_ptr->remove_note(fraction1_array_ptr,
								 phrase_ptr->iterator()->note_pntr()->note(), 1);
	 random_i = RANDOM(2);

	 if(upper_notes_i[0] > original_phrase_ptr->highnote() + 4)
		random_i = 1;
	 else if(lower_notes_i[0] < original_phrase_ptr->lownote() - 4)
		random_i = 0;

	 if(random_i == 0){
		note_p[a]->change_note(upper_notes_i[0]);
	 }else
		note_p[a]->change_note(lower_notes_i[0]);

	 if(avoid_element_i < 6){
		avoid_notes_i[avoid_element_i] = note_p[a]->note();
		avoid_element_i++;
	 }
	 a++;
  }while((phrase_ptr->iterator()->rhythm_block() == tmp_p)
			 &&(phrase_ptr->iterator()->rhythm_block()->rRlink()
				 != phrase_ptr->phrase()));

  // For ensuring no out of bounds elements //
  stored_i = a;

  for(a = 0; a < stored_i; a++)
	 phrase_ptr->add_note(location_array_i, note_p[a]);

  if(note_array_size_i > 1)
	 delete [] note_p;
  else
	 delete note_p;
}

void phrase_adapter_c::change_corr(int corr_change_type_i){
  int a;
  int random_i;
  int found_i;
  int left_note_i;
  int right_note_i;
  int upper_limit_i;
  int lower_limit_i;
  int tmp1_fraction_array_p[3];
  int tmp2_fraction_array_p[3];
  int new_end_fraction_p[3] = {0,0,0};
  int set_i = 1;

  corr_ptr->rhythm_analyse();

  if(corr_change_type_i == 0){
	 // Shuffles the existing correlation //
	 select_location(2);
	 if(fraction1_array_ptr != 0){
		tmp1_fraction_array_p[0] = fraction1_array_ptr[0];
		tmp1_fraction_array_p[1] = fraction1_array_ptr[1];
		tmp1_fraction_array_p[2] = fraction1_array_ptr[2];
		tmp2_fraction_array_p[0] = fraction2_array_ptr[0];
		tmp2_fraction_array_p[1] = fraction2_array_ptr[1];
		tmp2_fraction_array_p[2] = fraction2_array_ptr[2];
	 }else
		set_i = 0;
  }else if(corr_change_type_i == 1){
	 // Increases the correlation by shifting existing notes //
	 select_location(2);
	 if(fraction1_array_ptr != 0){
		tmp2_fraction_array_p[0] = fraction2_array_ptr[0];
		tmp2_fraction_array_p[1] = fraction2_array_ptr[1];
		tmp2_fraction_array_p[2] = fraction2_array_ptr[2];
	 }else
		set_i = 0;
	 select_location(2);
	 if(fraction1_array_ptr != 0){
		tmp1_fraction_array_p[0] = fraction1_array_ptr[0];
		tmp1_fraction_array_p[1] = fraction1_array_ptr[1];
		tmp1_fraction_array_p[2] = fraction1_array_ptr[2];
	 }else
		set_i = 0;
  }else if(corr_change_type_i == 2){
	 // Increases the correlation by adding a note to a gap //
	 tmp1_fraction_array_p[0] = 0;
	 tmp1_fraction_array_p[1] = 0;
	 tmp1_fraction_array_p[2] = 1;
	 select_location(2);
	 if(fraction1_array_ptr != 0){
		tmp2_fraction_array_p[0] = fraction2_array_ptr[0];
		tmp2_fraction_array_p[1] = fraction2_array_ptr[1];
		tmp2_fraction_array_p[2] = fraction2_array_ptr[2];
	 }else
		set_i = 0;
  }else if(corr_change_type_i == 3){
	 // Decreases the correlation by moving a match note to non-existing //
	 select_location(3);
	 select_location(1);
	 if((fraction1_array_ptr != 0)||(fraction_array_ptr[2] != 0)){
		tmp1_fraction_array_p[0] = fraction1_array_ptr[0];
		tmp1_fraction_array_p[1] = fraction1_array_ptr[1];
		tmp1_fraction_array_p[2] = fraction1_array_ptr[2];
		tmp2_fraction_array_p[0] = fraction_array_ptr[0];
		tmp2_fraction_array_p[1] = fraction_array_ptr[1];
		tmp2_fraction_array_p[2] = fraction_array_ptr[2];
	 }else
		set_i = 0;
  }else if(corr_change_type_i == 4){
	 // Adds a note to non-existing //
	 tmp1_fraction_array_p[0] = 0;
	 tmp1_fraction_array_p[1] = 0;
	 tmp1_fraction_array_p[2] = 1;
	 select_location(1);
	 if(fraction_array_ptr[2] != 0){
		tmp2_fraction_array_p[0] = fraction_array_ptr[0];
		tmp2_fraction_array_p[1] = fraction_array_ptr[1];
		tmp2_fraction_array_p[2] = fraction_array_ptr[2];
	 }else
		set_i = 0;
         cout << "Set for intro is " << endl;
  }
  phrase_ptr->add_fractions(growth_fraction_array_ptr, original_phrase_ptr->
									 phrase()->rLlink()->array(), new_end_fraction_p,0);

  if(((phrase_ptr->compare_fractions(tmp2_fraction_array_p, phrase_ptr->
		 phrase()->rLlink()->array()) <= 1)||((allow_phrase_growth_int == 1)
		 &&(phrase_ptr->compare_fractions(tmp2_fraction_array_p,
		 new_end_fraction_p) <= 1)))
		&&(((phrase_ptr->compare_fractions(tmp1_fraction_array_p, phrase_ptr->
		 phrase()->array()) == 1)&&(fix_start_note_location_int == 0))
		 ||((phrase_ptr->compare_fractions(tmp1_fraction_array_p, phrase_ptr->
		 phrase()->array()) != 1)))&&(set_i == 1)
		 &&(phrase_ptr->phrase()->rRlink() != phrase_ptr->phrase())
		 &&(phrase_ptr->compare_fractions(tmp1_fraction_array_p,
			 tmp2_fraction_array_p) != 1)){

    if((corr_change_type_i == 2)||(corr_change_type_i == 4)){
			 phrase_ptr->add_note(0, 0, 1, phrase_ptr->average_pitch(), 1,
							 phrase_ptr->average_velocity());
			 cout << "Added note for intro" << endl;
    }
	 found_i = phrase_ptr->find_rhythm_block(tmp1_fraction_array_p);

	 while(found_i == 1){
		phrase_ptr->shift_note(tmp1_fraction_array_p, phrase_ptr->iterator()->
									  note_pntr()->note(), tmp2_fraction_array_p);
		found_i = phrase_ptr->find_rhythm_block(tmp1_fraction_array_p);
	 }

	 phrase_ptr->find_rhythm_block(tmp2_fraction_array_p);

	 left_note_i = phrase_ptr->iterator()->rhythm_block()->rLlink()->
						note_pntr()->note();
	 right_note_i = phrase_ptr->iterator()->rhythm_block()->rRlink()->
						note_pntr()->note();
	 if(right_note_i >= left_note_i){
		upper_limit_i = right_note_i;
		lower_limit_i = left_note_i;
	 }else{
		upper_limit_i = left_note_i;
		lower_limit_i = right_note_i;
	 }
	 if(phrase_ptr->iterator()->note_pntr()->note() < lower_limit_i - 5){
		random_i = RANDOM(8);

		for(a = 0; a < phrase_ptr->iterator()->no_notes() + 1; a++){
		  phrase_ptr->iterator()->note_pntr()->adjust_pitch(random_i + 4);
		  phrase_ptr->iterator()->iterate(0, 0);
		}

	 }else if(phrase_ptr->iterator()->note_pntr()->note() > upper_limit_i + 5){
		random_i = RANDOM(8);

		for(a = 0; a < phrase_ptr->iterator()->no_notes() + 1; a++){
		  phrase_ptr->iterator()->note_pntr()->adjust_pitch(-random_i - 4);
		  phrase_ptr->iterator()->iterate(0, 0);
		}
	 }

	 fit_lengths(tmp2_fraction_array_p,1,1);
	 fit_lengths(tmp1_fraction_array_p,1,0);

	 phrase_ptr->find_rhythm_block(tmp2_fraction_array_p);
	 fraction1_array_ptr = phrase_ptr->iterator()->rhythm_block()->array();

	 change_note(0);
  }
}

void phrase_adapter_c::fit_lengths(int *fraction_array_p, int left_block_i,
											  int current_block_i){
  int a;
  double beat1_d;
  double beat2_d;

  phrase_ptr->find_rhythm_block(fraction_array_p);

  if((phrase_ptr->iterator()->rhythm_block() != phrase_ptr->phrase()->rLlink())
		&&(current_block_i == 1)){
	 beat1_d = phrase_ptr->iterator()->rhythm_block()->rRlink()->array()[0] +
		((1.0 * phrase_ptr->iterator()->rhythm_block()->rRlink()->array()[1])/
				 (phrase_ptr->iterator()->rhythm_block()->rRlink()->array()[2]));
	 beat2_d = phrase_ptr->iterator()->rhythm_block()->array()[0] +
		((1.0 * phrase_ptr->iterator()->rhythm_block()->array()[1])/
				 (phrase_ptr->iterator()->rhythm_block()->array()[2]));
	 for(a = 0; a < phrase_ptr->iterator()->no_notes() + 1; a++){
		if(phrase_ptr->iterator()->note_pntr()->length()
			!= (beat1_d - beat2_d)){
		  phrase_ptr->iterator()->note_pntr()->change_length(beat1_d - beat2_d);
		  phrase_ptr->iterator()->iterate(0, 0);
		}
	 }
  }
  phrase_ptr->find_rhythm_block(fraction_array_p);
  phrase_ptr->iterator()->iterate(1, 1);

  if((phrase_ptr->iterator()->rhythm_block() != phrase_ptr->phrase()->rLlink())
		&&(left_block_i == 1)){
	 beat1_d = phrase_ptr->iterator()->rhythm_block()->rRlink()->array()[0] +
		((1.0 * phrase_ptr->iterator()->rhythm_block()->rRlink()->array()[1])/
				 (phrase_ptr->iterator()->rhythm_block()->rRlink()->array()[2]));
	 beat2_d = phrase_ptr->iterator()->rhythm_block()->array()[0] +
		((1.0 * phrase_ptr->iterator()->rhythm_block()->array()[1])/
				 (phrase_ptr->iterator()->rhythm_block()->array()[2]));
	 for(a = 0; a < phrase_ptr->iterator()->no_notes() + 1; a++){
		if(phrase_ptr->iterator()->note_pntr()->length()
			!= (beat1_d - beat2_d)){
		  phrase_ptr->iterator()->note_pntr()->change_length(beat1_d - beat2_d);
		  phrase_ptr->iterator()->iterate(0, 0);
		}
	 }
  }
}

void phrase_adapter_c::eliminate(int eliminate_type_i){
  int random_i;
  int a;
  int count_i = 0;

  corr_ptr->rhythm_analyse();


  if((eliminate_type_i == 0)||(eliminate_type_i == 1)){
	 // Eliminate existing note, or note block //
	 select_location(0);
  }else{
	 // Eliminate match note, or match block //
	 select_location(3);
  }

  if((fraction1_array_ptr != 0)
		&&(((phrase_ptr->compare_fractions(fraction1_array_ptr, phrase_ptr->
		 phrase()->array()) == 1)&&(fix_start_note_location_int == 0))
		 ||((phrase_ptr->compare_fractions(fraction1_array_ptr, phrase_ptr->
		 phrase()->array()) != 1)))&&(phrase_ptr->phrase()->rRlink()->rRlink()
		 != phrase_ptr->phrase())){
    phrase_ptr->find_rhythm_block(fraction1_array_ptr);
	 do{
		random_i = RANDOM(phrase_ptr->iterator()->no_notes() + 1);
		for(a = 0; a < random_i; a++)
		  phrase_ptr->iterator()->iterate(0, 0);
		phrase_ptr->remove_note(fraction1_array_ptr, phrase_ptr->iterator()->
						note_pntr()->note(), 0);
		count_i++;
	 }while(((eliminate_type_i == 1)||(eliminate_type_i == 3))
			  &&(phrase_ptr->find_rhythm_block(fraction1_array_ptr) == 1));
  }
}

void phrase_adapter_c::find_notes(int *upper_notes_i, int *lower_notes_i,
											 int *avoid_notes_i){
  int current_note_i = phrase_ptr->iterator()->note_pntr()->note();
  int a;
  int b;
  int c = 0;
  int d = 0;
  int tmp_i;
  int note_limit_i = 12;

  // Identify notes that match base chord within range of selected note //
  for(a = 0; a < 4; a++){
	 for(b = 1; b <= note_limit_i; b++){
		if(((current_note_i + b)%12 == scale_ptr->base_chord()[a])&&(c < 4)
			&&(avoid_notes_i[0] != current_note_i + b)
			&&(avoid_notes_i[1] != current_note_i + b)
			&&(avoid_notes_i[2] != current_note_i + b)
			&&(avoid_notes_i[3] != current_note_i + b)
			&&(avoid_notes_i[4] != current_note_i + b)
			&&(avoid_notes_i[5] != current_note_i + b)){
		  upper_notes_i[c] = current_note_i + b;
		  c++;
		}
		if(((current_note_i - b)%12 == scale_ptr->base_chord()[a])&&(d < 4)
			&&(avoid_notes_i[0] != current_note_i - b)
			&&(avoid_notes_i[1] != current_note_i - b)
			&&(avoid_notes_i[2] != current_note_i - b)
			&&(avoid_notes_i[3] != current_note_i - b)
			&&(avoid_notes_i[4] != current_note_i - b)
			&&(avoid_notes_i[5] != current_note_i - b)){
		  lower_notes_i[d] = current_note_i - b;
		  d++;
		}
	 }
	 if(((c < 4)||(d < 4))&&(a == 3)){
		note_limit_i = note_limit_i + 2;
		a = -1;
	 }
  }

  a = 0;

  // Sort upper notes so that lowest is in lowest elements //
  while(a < 3){
	 if(upper_notes_i[a + 1] < upper_notes_i[a]){
		tmp_i = upper_notes_i[a + 1];
		upper_notes_i[a + 1] = upper_notes_i[a];
		upper_notes_i[a] = tmp_i;
		a = 0;
	 }else
		a++;
  }

  a = 0;

  // Sort lower notes so that highest is in lowest elements //
  while(a < 3){
	 if(lower_notes_i[a + 1] > lower_notes_i[a]){
		tmp_i = lower_notes_i[a + 1];
		lower_notes_i[a + 1] = lower_notes_i[a];
		lower_notes_i[a] = tmp_i;
		a = 0;
	 }else
		a++;
  }
  /*
  cout << "Upper Notes" << upper_notes_i[0] << ","
  << upper_notes_i[1] << ","
  << upper_notes_i[2] << ","
  << upper_notes_i[3] << endl;
  cout << "Lower Notes" << lower_notes_i[0] << ","
  << lower_notes_i[1] << ","
  << lower_notes_i[2] << ","
  << lower_notes_i[3] << endl;
  */
}
