#include <string.h>

#include "JName.h"
#include "assert.h"

bool
JNameBase::isNamed(const char *str) const
{
  if (str == 0)
    if (name() == 0) return true;

  if (name() == 0) return false;

  if (strcmp(str,name())==0) return true;

  return false;
}

JName::JName(const char *name)
  :_name(0)
{
  if (name != 0) 
    rename(name);
  else
    rename("NoName");
} 

void
JName::rename(const char *name)
{
  if (_name != 0) delete[] _name;

  _name = new char[strlen(name)+1];
  strcpy(_name,name);

}



JName::~JName()
{
  if (_name != 0 ) delete [] _name;
}


