/*
 ****************************************************************************
 *
 *	File:	pizzaDialog_cb.C
 *
 *	Function(s):
 *
 *	Description:
 *		pizzaDialog callback stubs, generated by the OI UIB.
 *
 *	RCSid = "$Id: pizzaDialog_cb.C,v 1.1.1.1 1993/06/10 17:14:17 mth Exp $"
 *
 ****************************************************************************
 */
#include <OI/oi.H>
#include "pizzaDialog.H"
#include "pizzaDialog_bd.H"

/*
 *	The following definitions are generated and read by the user
 *	interface builder to simplify the process of generating prototype
 *	stubs.
 *
 *	The user interface builder will ONLY preserve prototype stubs placed
 *	above the dividing line (below).  If you need to include additional
 *	header files to ensure that your program compiles, please include 
 *	them in
 *		pizzaDialog.H
 *
 *	CAVEAT
 *		These definitions ensure that a prototype stub is not
 *		regenerated.   PLEASE leave the definition here
 *		even if you move the stub to another file.
 *	
 */

extern void place_order (OI_menu_cell *, void *, OI_number);
extern void reset_display (OI_menu_cell *, void *, OI_number);
extern void set_price (OI_menu_cell *, void *, OI_number);


/* End of Function Declarations -- Protected User Code begins at next line */

/*
 ******************************************************************************
 *
 *	Function Name:	place_order
 *
 *		Description: 
 *			A cells action routine is invoked when the mouse
 *			pointer is over the cell and the SELECT mouse button
 *			is clicked.  Note that this implies the function is
 *			called when turning cells off as well as on, in
 *			persistant menus (excl, poly).
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			none.
 *
 ******************************************************************************
 */
void
place_order (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*,		// (input) ptr to user supplied argument
	OI_number	)		// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
/*
	Procedure:
*/
	if (cellp->selected()) {
		/*
		**	place order
		*/
	}

	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	reset_display
 *
 *		Description: 
 *			A cells action routine is invoked when the mouse
 *			pointer is over the cell and the SELECT mouse button
 *			is clicked.  Note that this implies the function is
 *			called when turning cells off as well as on, in
 *			persistant menus (excl, poly).
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			none.
 *
 ******************************************************************************
 */
void
reset_display (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*,		// (input) ptr to user supplied argument
	OI_number	)		// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		int	i;
		OI_menu	*mnu ;
/*
	Procedure:
*/
	if (cellp->selected()) {
		mnu = (OI_menu*) cellp->ancestor_derived_from( OI_dialog_box::clsp )->descendant( "size" );
		if (mnu)
			mnu->num_select( OI_YES, 0 );
		mnu = (OI_menu*) cellp->ancestor_derived_from( OI_dialog_box::clsp )->descendant( "toppings" );
		if (mnu) {
			for (i=mnu->num_cells(); i--;) {
				cellp = mnu->numbered_cell( i );
				if (cellp->selected())
					cellp->select( OI_NO );
			}
		}
	}

	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	set_price
 *
 *		Description: 
 *			A cells action routine is invoked when the mouse
 *			pointer is over the cell and the SELECT mouse button
 *			is clicked.  Note that this implies the function is
 *			called when turning cells off as well as on, in
 *			persistant menus (excl, poly).
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			none.
 *
 ******************************************************************************
 */
void
set_price (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*argp,		// (input) ptr to user supplied argument
	OI_number	button )	// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		OI_entry_field	*ent ;
		char	buf[64] ;
		int	price ;
/*
	Procedure:
*/
	ent = (OI_entry_field*) cellp->ancestor_derived_from( OI_dialog_box::clsp )->descendant( "price" );
	if (ent) {
		price = (int) ent->data();
		if (cellp->selected())
			price += (int) argp ;
		else
			price -= (int) argp ;
		sprintf( buf, "%.2f", ((float)price)/100. );
		ent->set_text( buf, OI_NO );
		ent->set_data( (void*) price );
	}

	return ;
}

