/* This file contains system-specific functions for generic UNIX.
 * The program pfdisk.c calls these routines.
 */
#include <stdio.h>
#include <fcntl.h>

#define extern
#include "sysdep.h"
#undef extern

int usage(prog)	/* print a usage message */
char	*prog;	/* program name */
{
  fprintf(stderr,"Usage: %s dev\n\
\twhere 'dev' is the device name, i.e. /dev/hd0\n\
\t(The device must start on absolute sector zero.)\n",prog);
}

void getGeometry(dev, c, h, s)
char	*dev;		/* device name */
unsigned *c,*h,*s;	/* cyls, heads, sectors */
{
  fprintf(stderr,
"\n\tWarning:  The device \"%s\" is assumed to have:\n\
\tcyls=%d, heads=%d, sectors=%d (an arbitrary guess).\n",
	  dev, *c, *h, *s);
  fprintf(stderr,
"\n\tThis program was compiled for generic UNIX and therefore\n\
\tdoes not know how to determine the disk parameters.  You must\n\
\tdescribe the disk geometry manually, using the 'G' command.\n");
}

int getFile(name, buf, len)	/* read file into buffer */
char	*name, *buf;
int	len;
{	/* (open, read, close) */
  int devfd, retval;
  
  devfd = open(name, O_RDONLY, 0);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for reading\n", name);
    return(devfd);
  }
  retval = read(devfd, buf, len);
  if (retval < 0)
    fprintf(stderr,"%s: read failed\n", name);
  close(devfd);
  return(retval);
}

int putFile(name, buf, len)	/* write buffer to file */
char	*name, *buf;
int	len;
{	/* (open, write, close) */
  int devfd, retval;
  
  devfd = open(name, O_WRONLY|O_CREAT, 0666);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for writing\n", name);
    return(devfd);
  }
  retval = write(devfd, buf, len);
  if (retval < 0)
    fprintf(stderr,"%s: write failed\n", name);
  close(devfd);
  return(retval);
}

int getBBlk(devname, buffer)	/* read block into buffer */
char	*devname, *buffer;	/* (open, read, close) */
{
  int devfd, retval;
  
  devfd = open(devname,O_RDONLY);
  if (devfd < 0) {
    printf("%s: can't open for read\n", devname);
    return(devfd);
  }
  retval = read(devfd, buffer, SECSIZE);
  close(devfd);
  return(retval);
}

int putBBlk(devname, buffer)	/* write buffer to device */
char	*devname, *buffer;	/* (open, write, close) */
{
  int devfd, retval;
  
  devfd = open(devname,O_WRONLY);
  if (devfd < 0) {
    printf("%s: can't open for write\n",devname);
    return(devfd);
  }
  retval = write(devfd, buffer, SECSIZE);
  sync();
  close(devfd);
  return(retval);
}
