/* This file contains system-specific functions suitable for
 * most AT&T System V/386 variants (ISC,SCO,Intel...).
 * The program pfdisk.c calls these routines.
 */
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/vtoc.h>

#define extern
#include "sysdep.h"
#undef extern

int usage(prog)	/* print a usage message */
char	*prog;	/* program name */
{
  fprintf(stderr,"Usage: %s dev\n\
	where 'dev' is the device name, i.e. /dev/rdsk/0p0\n\
	(The device must start on absolute sector zero.)\n",prog);
}

void getGeometry(dev, c, h, s)
char	*dev;		/* device name */
unsigned *c,*h,*s;	/* cyls, heads, sectors */
{
  int devfd, retval;
  struct disk_parms dp;
  
  devfd = open(dev, O_RDONLY, 0);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for reading\n", dev);
    return;
  }
  retval = ioctl(devfd, V_GETPARMS, &dp);
  close(devfd);
  if (retval < 0) {
    fprintf(stderr,"%s: can't get disk parameters\n", dev);
    return;
  }
  if (dp.dp_type != DPT_WINI) {
    fprintf(stderr,"%s: not a Winchester Disk\n", dev);
    return;
  }
  *c = dp.dp_cyls;
  *h = dp.dp_heads;
  *s = dp.dp_sectors;
}

int getFile(name, buf, len)	/* read file into buffer */
char	*name, *buf;
int	len;
{	/* (open, read, close) */
  int devfd, retval;
  
  devfd = open(name, O_RDONLY, 0);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for reading\n", name);
    return(devfd);
  }
  retval = read(devfd, buf, len);
  if (retval < 0)
    fprintf(stderr,"%s: read failed\n", name);
  close(devfd);
  return(retval);
}

int putFile(name, buf, len)	/* write buffer to file */
char	*name, *buf;
int	len;
{	/* (open, write, close) */
  int devfd, retval;
  
  devfd = open(name, O_WRONLY|O_CREAT, 0666);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for writing\n", name);
    return(devfd);
  }
  retval = write(devfd, buf, len);
  if (retval < 0)
    fprintf(stderr,"%s: write failed\n", name);
  close(devfd);
  return(retval);
}

int getBBlk(devname, buffer)	/* read block into buffer */
char	*devname, *buffer;	/* (open, read, close) */
{
  int devfd, retval;
  
  devfd = open(devname,O_RDONLY);
  if (devfd < 0) {
    printf("%s: can't open for read\n", devname);
    return(devfd);
  }
  retval = read(devfd, buffer, SECSIZE);
  close(devfd);
  return(retval);
}

int putBBlk(devname, buffer)	/* write buffer to device */
char	*devname, *buffer;	/* (open, write, close) */
{
  int devfd, retval;
  
  devfd = open(devname,O_WRONLY);
  if (devfd < 0) {
    printf("%s: can't open for write\n",devname);
    return(devfd);
  }
  retval = write(devfd, buffer, SECSIZE);
  sync();
  close(devfd);
  return(retval);
}
