#include <stdio.h>

static unsigned char key_map_finnish[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  '+', '\'',  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '}',    0,   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  '|',
    '{',    0,    0, '\'',  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char shift_map_finnish[] = {
      0,   27,  '!', '\"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  '`',  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  ']',  '^',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L', '\\',
    '[',    0,    0,  '*',  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_finnish[] = {
      0,    0,    0,  '@',  163,  '$',    0,    0,
    '{',   '[',  ']', '}', '\\',    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,  '~',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };


static unsigned char key_map_finnish_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  '+',  180,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  229,  168,   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  246,
    228,  167,    0, '\'',  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };
  
static unsigned char shift_map_finnish_latin1[] = {
      0,   27,  '!',  '"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  '`',  127,    9,
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  197,  '^',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  214,
    196,  189,    0,  '*',  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_finnish_latin1[] = {
      0,    0,    0,  '@',  163,  '$',    0,    0,
    '{',  '[',  ']',  '}', '\\',    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,  '~',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };


static unsigned char key_map_us[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  '-',  '=',  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '[',  ']',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  ';',
   '\'',  '`',    0, '\\',  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '/',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0, 
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char shift_map_us[] = {
      0,   27,  '!',  '@',  '#',  '$',  '%',  '^',
    '&',  '*',  '(',  ')',  '_',  '+',  127,    9,
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '{',  '}',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  ':',
    '"',  '~',  '0',  '|',  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  '<',  '>',  '?',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0, 
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_us[] = {
      0,    0,    0,  '@',    0,  '$',    0,    0,
    '{',   '[',  ']', '}', '\\',    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,  '~',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };


static unsigned char key_map_uk[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  '-',  '=',  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '[',  ']',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  ';',
   '\'',  '`',    0,  '#',  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '/',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0, 
      0,    0,    0,    0,    0,    0, '\\',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char shift_map_uk[] = {
      0,   27,  '!',  '"',  163,  '$',  '%',  '^',
    '&',  '*',  '(',  ')',  '_',  '+',  127,    9,
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '{',  '}',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  ':',
    '@',  '~',  '0',  '~',  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  '<',  '>',  '?',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0, 
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_uk[] = {
      0,    0,    0,  '@',    0,  '$',    0,    0,
    '{',   '[',  ']', '}', '\\',    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,  '~',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };


static unsigned char key_map_gr[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\\', '\'',  127,    9,
    'q',  'w',  'e',  'r',  't',  'z',  'u',  'i',
    'o',  'p',  '@',  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  '[',
    ']',  '^',    0,  '#',  'y',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_gr[] = {
      0,   27,  '!',  '"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  '`',  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Z',  'U',  'I',
    'O',  'P', '\\',  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  '{',
    '}',  '~',    0, '\'',  'Y',  'X',  'C',  'V',
        'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_gr[] = {
      0,    0,    0,  '@',    0,  '$',    0,    0,
        '{',   '[',  ']', '}', '\\',    0,    0,    0,
        '@',    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  '~',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,  '|',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_gr_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', 223,  180,  127,    9,
    'q',  'w',  'e',  'r',  't',  'z',  'u',  'i',
    'o',  'p',  252,  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l', 246,
    228,   94,    0,  '#',  'y',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_gr_latin1[] = {
      0,   27,  '!',  '"',  167,  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  '`',  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Z',  'U',  'I',
    'O',  'P',  220,  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  214,
        196,  176,    0, '\'',  'Y',  'X',  'C',  'V',
        'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_gr_latin1[] = {
      0,    0,    0,  178,  179,  '$',    0,    0,
        '{',   '[',  ']', '}', '\\',    0,    0,    0,
        '@',    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  '~',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  181,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,  '|',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_fr[] = {
      0,   27,  '&',  '{',  '"', '\'',  '(',  '-',
    '}',  '_',  '/',  '@',  ')',  '=',  127,    9,
    'a',  'z',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '^',  '$',   13,    0,  'q',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  'm',
    '|',  '`',    0,   42,  'w',  'x',  'c',  'v',
    'b',  'n',  ',',  ';',  ':',  '!',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_fr[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  ']',  '+',  127,    9, 
    'A',  'Z',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '<',  '>',   13,    0,  'Q',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  'M',
    '%',  '~',    0,  '#',  'W',  'X',  'C',  'V',
        'B',  'N',  '?',  '.',  '/', '\\',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_fr[] = {
      0,    0,    0,  '~',  '#',  '{',  '[',  '|',
        '`', '\\',   '^',  '@', ']',  '}',    0,    0,
        '@',    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  '~',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,  '|',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_fr_latin1[] = {
      0,   27,  '&',  233,  '"', '\'',  '(',  '-',
        232,  '_',  231,  224,  ')',  '=',  127,    9,
    'a',  'z',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '^',  '$',   13,    0,  'q',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  'm',
    249,  178,    0,   42,  'w',  'x',  'c',  'v',
    'b',  'n',  ',',  ';',  ':',  '!',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_fr_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  176,  '+',  127,    9, 
    'A',  'Z',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  168,  163,   13,    0,  'Q',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  'M',
    '%',    0,    0,  181,  'W',  'X',  'C',  'V',
        'B',  'N',  '?',  '.',  '/',  167,    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_fr_latin1[] = {
      0,    0,    0,  '~',  '#',  '{',  '[',  '|',
        '`', '\\',   '^',  '@', ']',  '}',    0,    0,
        '@',    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  164,   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,  '|',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_dk[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  '+', '\'',  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  229,    0,   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  230,
    162,    0,    0, '\'',  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_dk[] = {
      0,   27,  '!', '\"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  '`',  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  197,  '^',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  198,
    165,    0,    0,  '*',  'Z',  'X',  'C',  'V',
        'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_dk[] = {
      0,    0,    0,  '@',  163,  '$',    0,    0,
        '{',   '[',  ']', '}',    0,  '|',    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  '~',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,  '\\',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_dk_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0',  '+',  180,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  229,  168,   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  230,
    162,  189,    0, '\'',  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_dk_latin1[] = {
      0,   27,  '!', '\"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  '`',  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  197,  '^',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  198,
    165,  167,    0,  '*',  'Z',  'X',  'C',  'V',
        'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

static unsigned char alt_map_dk_latin1[] = {
      0,    0,    0,  '@',  163,  '$',    0,    0,
        '{',   '[',  ']', '}',    0,  '|',    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  '~',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0, '\\',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_dvorak[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\\',  '=',  127,    9,
       '\'',  ',',  '.',  'p',  'y',  'f',  'g',  'c',
        'r',  'l',  '/',  ']',   13,    0,  'a',  'o',
    'e',  'u',  'i',  'd',  'h',  't',  'n',  's',
        '-',  '`',    0,  '[',  ';',  'q',  'j',  'k',
    'x',  'b',  'm',  'w',  'v',  'z',    0,  '*',
          0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char shift_map_dvorak[] = {
      0,   27,  '!',  '@',  '#',  '$',  '%',  '^',
    '&',  '*',  '(',  ')',  '|',  '+',  127,    9,
        '"',  '<',  '>',  'P',  'Y',  'F',  'G',  'C',
    'R',  'L',  '?',  '}',   13,    0,  'A',  'O',
    'E',  'U',  'I',  'D',  'H',  'T',  'N',  'S',
    '_',  '~',    0,  '{',  ':',  'Q',  'J',  'K',
    'X',  'B',  'M',  'W',  'V',  'Z',    0,  '*',
          0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char alt_map_dvorak[] = {
      0,    0,    0,  '@',    0,  '$',    0,    0,
        '{',   '[',  ']', '}', '\\',    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,  '~',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,  '|',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


static unsigned char key_map_sg[] = {
          0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
        '7',  '8',  '9',  '0', '\'',  '^',  127,    9,
        'q',  'w',  'e',  'r',  't',  'z',  'u',  'i',
        'o',  'p',    0,    0,   13,    0,  'a',  's',
        'd',  'f',  'g',  'h',  'j',  'k',  'l',    0,
          0,    0,    0,  '$',  'y',  'x',  'c',  'v',
        'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
          0,   32,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };
static unsigned char shift_map_sg[] = {
          0,   27,  '+',  '"',  '*',    0,  '%',  '&',
        '/',  '(',  ')',  '=',  '?',  '`',  127,    9,
        'Q',  'W',  'E',  'R',  'T',  'Z',  'U',  'I',
        'O',  'P',    0,  '!',   13,    0,  'A',  'S',
        'D',  'F',  'G',  'H',  'J',  'K',  'L',    0,
          0,    0,    0,    0,  'Y',  'X',  'C',  'V',
        'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
          0,   32,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '>',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };
static unsigned char alt_map_sg[] = {
          0,    0,    0,  '@',  '#',    0,    0,    0,
        '|',    0,    0,    0, '\'',  '~',    0,    0,
        '@',    0,    0,    0,    0,    0,    0,    0,
          0,    0,   '[',  ']',  13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
        '{',    0,    0,  '}',    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0, '\\',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };

static unsigned char key_map_sg_latin1[] = {
          0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
        '7',  '8',  '9',  '0', '\'',  '^',  127,    9,
        'q',  'w',  'e',  'r',  't',  'z',  'u',  'i',
        'o',  'p',  252,    0,   13,    0,  'a',  's',
        'd',  'f',  'g',  'h',  'j',  'k',  'l',  246,
        228,  167,    0,  '$',  'y',  'x',  'c',  'v',
        'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
          0,   32,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '<',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };
static unsigned char shift_map_sg_latin1[] = {
          0,   27,  '+',  '"',  '*',  231,  '%',  '&',
        '/',  '(',  ')',  '=',  '?',  '`',  127,    9,
        'Q',  'W',  'E',  'R',  'T',  'Z',  'U',  'I',
        'O',  'P',  220,  '!',   13,    0,  'A',  'S',
        'D',  'F',  'G',  'H',  'J',  'K',  'L',  214,
        196,  176,    0,  163,  'Y',  'X',  'C',  'V',
        'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
          0,   32,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '-',    0,    0,    0,  '+',    0,
          0,    0,    0,    0,    0,    0,  '>',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };
static unsigned char alt_map_sg_latin1[] = {
          0,    0,    0,  '@',  '#',    0,    0,  172,
        '|',  162,    0,    0, '\'',  '~',    0,    0,
        '@',    0,    0,    0,    0,    0,    0,    0,
          0,    0,  '[',  ']',   13,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,  233,
        '{',    0,    0,  '}',    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0, '\\',    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0 };


#define MAX_KBD_TYPE    13
#define SIZE_OF_MAPS    (sizeof(key_map_fr)*3)

#define TRUE 1
#define FALSE 0

typedef struct {  
    char *  kbd_type;
    unsigned char * kbd_start;
} T_map_table;

T_map_table V_map_table [MAX_KBD_TYPE] = {
    { "KBD_FINNISH", key_map_finnish},
    { "KBD_FINNISH_LATIN1", key_map_finnish_latin1},
    { "KBD_US", key_map_us},
    { "KBD_UK", key_map_uk},
    { "KBD_GR", key_map_gr},
    { "KBD_GR_LATIN1", key_map_gr_latin1},
    { "KBD_FR", key_map_fr},
    { "KBD_FR_LATIN1", key_map_fr_latin1},
    { "KBD_DK", key_map_dk},
    { "KBD_DK_LATIN1", key_map_dk_latin1},
    { "KBD_DVORAK", key_map_dvorak},
    { "KBD_SG", key_map_sg},
    { "KBD_SG_LATIN1", key_map_sg_latin1}
};

void usage(void)
{
	int L_i;

    fprintf(stderr,"usage :  fixkbd [-pKBD_TYPE] kernel_file\n");
	fprintf(stderr,"    where KBD_TYPE is one of the following...\n");
	for (L_i=0;L_i<MAX_KBD_TYPE; L_i++) {
		fprintf(stderr,"    - %s\n", V_map_table[L_i].kbd_type);
	}
		
}

int F_get_kbd_type_index( char * P_kbd_type )
{
	int L_i;

	for (L_i=0; L_i<MAX_KBD_TYPE; L_i++) {
		if (strcmp (P_kbd_type, V_map_table[L_i].kbd_type) == 0 )
			break;
	}

	return(L_i);
}


 
int main (int argc, char *argv[])
{
    FILE *fdin; 
    int L_i;
    char *L_filename_ptr;
    char *L_kbd_type_ptr;
    unsigned char * L_block_ptr;
    unsigned char * L_ptr_end;
    unsigned char * L_ptr;
    int L_file_size;
    int L_kbd_index;
    int L_finish;

	/* -- check nb of args -- */
    if ( argc < 2 ) {
		usage();
		exit(1);
    } else {

		/* -- check if we have the patch option -- */
		if (argc == 3) {

			L_filename_ptr = argv[2];
			/* -- get keyboard type -- */
			if ( strncmp(argv[1],"-p",2) == 0) {
				L_kbd_type_ptr = (argv[1]+2);
				/* -- check if this board type is correct -- */
				if ( (L_kbd_index = F_get_kbd_type_index(L_kbd_type_ptr)) 
					         == MAX_KBD_TYPE) {
					usage();
					exit(4);
				}
			} else {
				usage();
				exit(1);
			}
				

		} else {
			L_filename_ptr = argv[1];
			L_kbd_index = MAX_KBD_TYPE;
		}

	} /* end if */

    /* -- open the file to fix -- */
    if ( (fdin = fopen(L_filename_ptr, "r+b")) == NULL ) {
		fprintf(stderr,"\nCan't open %s\n",L_filename_ptr);
        exit(2);
    }

    /* -- go to the end of file and get the offset
          (= to size) and rewind  -- */
    fseek(fdin,0L,SEEK_END);
    L_file_size = ftell(fdin);
    rewind(fdin);
    printf("Size of file is : %ld bytes\n",L_file_size);

    /* -- allocate a block of memory for the whole file -- */
    if ( (L_block_ptr = (unsigned char *)  malloc (L_file_size)) == NULL ) {
    printf("Can't allocate memory !\n");
    exit(3);
    }
    
    /* -- load the whole file -- */
    printf("Loading the kernel file in memory, please wait...\n");
    if (fread(L_block_ptr, L_file_size, 1, fdin) !=1 ) {
        fprintf(stderr,"Can't read file content\n");
        exit(4);
    }


	/* -- scan image file -- */
	L_ptr_end = (L_block_ptr+L_file_size-SIZE_OF_MAPS);
	L_ptr = L_block_ptr;
        L_finish = FALSE;
	while ( (L_ptr < L_ptr_end) && !L_finish ) {

		/* -- check all possible keyboards -- */
		for (L_i=0; L_i<MAX_KBD_TYPE; L_i++) {

			if ( memcmp(L_ptr, V_map_table[L_i].kbd_start, SIZE_OF_MAPS)==0) {
				printf("Keyboard table found at offset : 0x%lx\n",
					   (L_ptr - L_block_ptr));
				printf("Current type of keyboard is %s\n",
					   V_map_table[L_i].kbd_type);

				/* -- now look if we have to patch -- */
				if (L_kbd_index != MAX_KBD_TYPE) {

					printf("New type of keyboard will be %s\n",
						   V_map_table[L_kbd_index].kbd_type);

					fseek(fdin, (int) (L_ptr - L_block_ptr),SEEK_SET);
  					if (fwrite(V_map_table[L_kbd_index].kbd_start, SIZE_OF_MAPS,
						   1 ,fdin) != 1) {
						fprintf(stderr,"Can't write to file\n");
						exit(4);
					}
					fclose(fdin);
				}

				/* -- here we are done -- */
                                L_finish = TRUE;
                                break;

			} /* end if */

		} /* end for */

		L_ptr++;

	} /*end while */

        free(L_block_ptr);
	exit(0);
}

