#include <linux/sched.h>
#include <linux/tty.h>
#include <asm/segment.h>

#include <signal.h>

struct {
	int flag;
	int present[NR_TASKS];
	struct task_struct tasks[NR_TASKS];
} task_data;

void show_taskuse(int nr,struct task_struct * p, int flag)
{
	char *c = "RIUZS.";
	int state = p->state;
	if ((state>4) || (state<0))
		state=5;
	printf("%4d: pid=%-4d state=%c ",nr,p->pid,c[state]);
	if (!flag)
	{ 
		if (p->tty < 0)
			printf("-    ");
		else
		if (IS_A_PTY_MASTER(p->tty))
			printf("ptyp%x",p->tty-128);
		else
		if (IS_A_PTY_SLAVE(p->tty))
			printf("ttyp%x",p->tty-192);
		else
			printf("tty%x ",p->tty);
		printf(" pgrp:%-5d %s\n", p->pgrp, p->executable_name);
	}  
	else
		printf("ctime=%-6d stime=%-8d cutime=%-5d cstime=%-5d\n", 
			p->utime,p->stime, p->cutime,p->cstime);
}


void show_use(int flag)
{
	int i;

	for (i=0;i<NR_TASKS;i++)
		if (task_data.present[i])
			show_taskuse(i,&task_data.tasks[i],flag);
}


int main(int argc, char *argv[])
{
	int psflag = 0;
	task_data.flag = 1; 
	if (ioctl(0, TIOCLINUX, &task_data )<0)
		printf("couldn't ioctl kernel");
	else
	{
		show_use(argc==2);
	}
	
}
