
      SUBROUTINE DVDIR (SENSE, GAUGE, U, V)
C     ---------------------------------------

      INCLUDE    'qcd2.inc'

      INTEGER     SENSE
      DOUBLE PRECISION    GAUGE ( NSITES/2, NCOLOR, NCOLOR, NCMPLX )
      DOUBLE PRECISION    U ( NSITES/2, NCOLOR, NCMPLX ),
     *                    V ( NSITES/2, NCOLOR, NCMPLX )

C     -----------------------------------------------------------------------
C     |  Calculates :                                                       |
C     |                                                                     |
C     |          v (i) = D (i,j) * u (j),                                   |
C     |                                                                     |
C     |  for all sites 'i' at which {v} is defined (i.e. all even or odd    |
C     |  sites), for a particular link direction and sense.                 |
C     |                                                                     |
C     |  'sense'  =  sense of the link (ij)                                 |
C     |              (positive = 'psense', negative = 'nsense'              |
C     |                                                                     |
C     |        This subroutine is called with the arrays {u}, {v} and       |
C     |  [gauge] all aligned, such that the corresponding elements,         |
C     |  v (i), gauge (i,j) and u (j), are stored at the same array         |
C     |   positions.   Thus the inner loop over sites can be VECTORISED !   |
C     |                                                                     |
C     -----------------------------------------------------------------------
      INTEGER     TDIR,  XDIR,  YDIR,  ZDIR,  EVEN,  ODD,
     *            PSENSE,  NSENSE,  PLUS,  MINUS,  RE,  IM
      PARAMETER ( TDIR = 1,    XDIR = 2,    YDIR = 3,    ZDIR = 4,
     *            EVEN = 0,     ODD = 1,   PSENSE= 0,   NSENSE= 1,
     *            PLUS = 0,   MINUS = 1,      RE = 1,      IM = 2 )
      INTEGER  SITE,  I

      IF  (SENSE  .EQ.  PSENSE) THEN
C     --------------------------------
C     -----------------------------------------------------------------------
C     |  Positive sense link                                                |
C     |  -------------------                                                |
C     |       v (i) = D (i,j) * u (j),   where site j = (i+mu).             |
C     |                                                                     |
C     |       In this case,  D(i,j) = gauge(i)  (only that segment of       |
C     |  the total gauge field array corresponding to the given link        |
C     |  direction and sense is passed in).   Also, the {u} vector          |
C     |  that is input has been shifted so that the sites are aligned:      |
C     |  u (i) = 'real' u (j).   Thus, we calculate:                        |
C     |                                                                     |
C     |       v (i) = gauge (i) * u (i)     for all sites 'i'               |
C     -----------------------------------------------------------------------
          DO 110  I = 1, NCOLOR
            DO 100  SITE = 1, NSITES/2

              V (SITE, I, RE) =
     *                       GAUGE (SITE, I, 1, RE) * U (SITE, 1, RE)       
     *                     - GAUGE (SITE, I, 1, IM) * U (SITE, 1, IM)
     *                     + GAUGE (SITE, I, 2, RE) * U (SITE, 2, RE)
     *                     - GAUGE (SITE, I, 2, IM) * U (SITE, 2, IM)
     *                     + GAUGE (SITE, I, 3, RE) * U (SITE, 3, RE)
     *                     - GAUGE (SITE, I, 3, IM) * U (SITE, 3, IM)

              V (SITE, I, IM) =
     *                       GAUGE (SITE, I, 1, RE) * U (SITE, 1, IM)
     *                     + GAUGE (SITE, I, 1, IM) * U (SITE, 1, RE)
     *                     + GAUGE (SITE, I, 2, RE) * U (SITE, 2, IM)
     *                     + GAUGE (SITE, I, 2, IM) * U (SITE, 2, RE)
     *                     + GAUGE (SITE, I, 3, RE) * U (SITE, 3, IM)
     *                     + GAUGE (SITE, I, 3, IM) * U (SITE, 3, RE)

 100        CONTINUE
 110      CONTINUE

        ELSE
C       ----
C     -----------------------------------------------------------------------
C     |  Negative sense link                                                |
C     |  -------------------                                                |
C     |       v (i) = D (i,j) * u (j),   where site j = (i-mu).             |
C     |                                                                     |
C     |       In this case,  D(i,j) = - herm.conj [ gauge(j,i) ]            |
C     |                             = - herm.conj [ gauge (j) ]             |
C     |                                                                     |
C     |  since only that segment of the total gauge field array             |
C     |  corresponding to the given link direction and sense is passed      |
C     |  in.   Also, the {v} vector that is input has been shifted so       |
C     |  that the sites are aligned:   v (j) = 'real' v (i).                | 
C     |       Thus, we calculate:                                           |
C     |                                                                     |
C     |  v (j)  =  - herm.conj [ gauge (j) ] * u (j)      for all sites 'j' |
C     -----------------------------------------------------------------------
          DO 210  I = 1, NCOLOR
            DO 200  SITE = 1, NSITES/2

              V (SITE, I, RE) =
     *                  - (  GAUGE (SITE, 1, I, RE) * U (SITE, 1, RE)       
     *                     + GAUGE (SITE, 1, I, IM) * U (SITE, 1, IM)
     *                     + GAUGE (SITE, 2, I, RE) * U (SITE, 2, RE)
     *                     + GAUGE (SITE, 2, I, IM) * U (SITE, 2, IM)
     *                     + GAUGE (SITE, 3, I, RE) * U (SITE, 3, RE)
     *                     + GAUGE (SITE, 3, I, IM) * U (SITE, 3, IM) )

              V (SITE, I, IM) =
     *                     - GAUGE (SITE, 1, I, RE) * U (SITE, 1, IM)
     *                     + GAUGE (SITE, 1, I, IM) * U (SITE, 1, RE)
     *                     - GAUGE (SITE, 2, I, RE) * U (SITE, 2, IM)
     *                     + GAUGE (SITE, 2, I, IM) * U (SITE, 2, RE)
     *                     - GAUGE (SITE, 3, I, RE) * U (SITE, 3, IM)
     *                     + GAUGE (SITE, 3, I, IM) * U (SITE, 3, RE)

 200        CONTINUE
 210      CONTINUE
      ENDIF

      END
