
      SUBROUTINE CGITER ( X, P, R, FP, DV, RSQ )
C     ------------------------------------------

      INTEGER VSIZE
      COMMON /VECLEN/ VSIZE

      DOUBLE PRECISION   X( VSIZE ), P(VSIZE), R(VSIZE)
      DOUBLE PRECISION   FP( VSIZE ), DV( VSIZE )
      DOUBLE PRECISION   ALPHA,  NEWRSQ,  PFP,  SCPROD, RSQ

C     ------------------------------------------------------------
C     |  One iteration of the Conjugate Gradient (CG) algorithm  |
C     |  - no preconditioning.                                   |
C     ------------------------------------------------------------


C     -----------------------------------
C     |   alpha  =  (r, r) / (p, Fp)    |
C     -----------------------------------
      CALL FVEC (P, FP, DV)

      PFP    =  SCPROD (P, FP)
      ALPHA  =  RSQ / PFP


C     --------------------------------------
C     |   {new.x}  =  {x} + alpha * {p}    |
C     --------------------------------------
      CALL ADDSCV (X, X, ALPHA, P)


C     --------------------------------------
C     |   {new.r}  =  {r} - alpha * {Fp}   |
C     --------------------------------------
      CALL ADDSCV (R, R, -ALPHA, FP)


C     ----------------------------------------------------------------
C     |   {new.p}  =  ((new.r, new.r) / (r, r)) * {p}  +  {new.r}    |
C     ----------------------------------------------------------------
      NEWRSQ =  SCPROD (R, R)
      CALL ADDSCV (P, R, (NEWRSQ / RSQ), P)
      RSQ    =  NEWRSQ

      END
