/* template.c - your comments here */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/dehelp.c,v 8.0 91/07/17 13:18:39 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/dehelp.c,v 8.0 91/07/17 13:18:39 isode Rel $
 *
 *
 * $Log:	dehelp.c,v $
 * Revision 8.0  91/07/17  13:18:39  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#include <ctype.h>
#include "demanifest.h"
#include "tailor.h"
#include "quipu/util.h"
#include "logger.h"

extern LLog *de_log;

static struct {
	char *topic;
	char *fullname;
	int unique;
} helpTopics[] = {
	"browse", NULLCP, 1,
	"commands", NULLCP, 3,
	"country", NULLCP, 3,
	"cricket", NULLCP, 2,
	"department", NULLCP, 1,
	"dept", "department", 4,
	"ex1", NULLCP, 3,
	"ex2", NULLCP, 3,
	"help", NULLCP, 1,
	"intro", NULLCP, 1,
	"name", NULLCP, 1,
	"organisation", NULLCP, 3,
	"orginfo", NULLCP, 4,
	"person", "name", 1,
	"termtypes", NULLCP, 1,
	"welcome", NULLCP, 2,
	"wildcards", NULLCP, 2,
	NULLCP, NULLCP, 0
};

char *
findHelp(helpstr)
char * helpstr;
{
int i, n;
char * cp;

	for (cp = helpstr; *cp != '\0'; cp++)
		if (isupper(*cp))
			*cp = tolower(*cp);
	for (i = 0; helpTopics[i].unique != 0; i++)
	{
		if ((n = strlen(helpstr)) >= helpTopics[i].unique)
			if (strncmp(helpTopics[i].topic, helpstr, n) == 0)
				if (helpTopics[i].fullname == NULLCP)
					return(helpTopics[i].topic);
				else
					return(helpTopics[i].fullname);
	}
	return(helpstr);
}

displayHelp(helpstr)
char * helpstr;
{
FILE *help_file;
char linebuf[LINESIZE];
char str[LINESIZE];

  (void) strcpy(str,"de/de");
  (void) strcat(str, helpstr);
  if ((help_file = fopen(isodefile(str, 0), "r")) == (FILE *) NULL)
  {
    (void) ll_log (de_log, LLOG_NOTICE, NULLCP, "NoHelp: %s", str + 5);
    (void) fprintf(stderr, "No help available for `%s'\n", helpstr);
    (void) fprintf(stderr, "\nHELP about HELP available by typing ??\n\n");
  }
  else 
  {
    pagerOn(NUMBER_NOT_ALLOWED);
    (void) ll_log (de_log, LLOG_NOTICE, NULLCP, "Help: %s", str + 5);
    while(fgets(linebuf, sizeof(linebuf), help_file) != NULLCP)
      pageprint("%s",linebuf);
    (void) fclose(help_file);
    pageprint("\nHELP about HELP available by typing ??\n\n");
  }
}

