// --------------------------------------------------------------------
//          DSP CW filter - Control and User Interface    
//      Demo software accompanying the  QEX  August  1994 article:	       
//      "Using a Programmable PC Sound Card for Amateur Radio"         
//                  (c) Johan Forrer, KC7WW			       
//		     26553 Priceview Drive                             
//                    Monroe, OR 97456				       
// --------------------------------------------------------------------
//								       
//     Compilation/link instructions for Borland C++                                  
//     >bcc -c -ml cw250.cpp
//     >tlink /x c:\bc4\lib\c0l cw250 PSA1.obj PSA2.obj,, emu mathl cl
//								       
// --------------------------------------------------------------------
//              This is how the AD1848 is reprogrammed:
// --------------------------------------------------------------------
// Idx=0
// Sta=0
//  0 =47    select left  line, gain =7
//  1 =47    select right line, gain =7
//  2 =0x80  mute left  aux#1
//  3 =0x80  mute right aux#1
//  4 =0x80  mute left  aux#2
//  5 =0x80  mute right aux#2
//  6 =0x07  left  DAC with some attenuation
//  7 =0x07  right DAC with some attenuation
//  8 =0x51  16 bit 2s compl, linear PCM, stereo, 
//           xtal1=16.93MHz, 5512.5 kHz,
//  9 =0x08  DMA capture/playback, Autocalibrate after mode change,
//           disable capture/playback, dual DMA mode
// 10 =0     N.A
// 11 =0     N.A
// 12 =0     N.A
// 13 =0     digital mix muted
// 14 =0     base count = 0
// 15 =0     base count = 0
// --------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <dos.h>

#include "psa.h"

// --------------------------------------------------------------------
// Local function prototypes
// --------------------------------------------------------------------
void start_application(char *, unsigned char *);
void terminate_application(void);
void timer_test(void);

//--------------------------------------------------------------------
// Global data
//--------------------------------------------------------------------
int tick;  			// a global tick counter
extern unsigned int wssbase;	// Defined in PSAUTIL.CPP

#define MON "cwmon.ld" 		// define name of bootstrap
#define APP "cw250.cde"		// define name of application

void main()
{
unsigned char initstate[18]={0,0,0x87,0x87,0x80,0x80,0x80,
		0x80,0x07,0x07,0x51,0x08,0,0,0,0,0,0};

// -------------------------------------------------------------------------
// Announce who we are and what the program is about
// -------------------------------------------------------------------------
	printf("Demo program to set up and communicate with a PSA sound card\n");
	printf("By Johan Forrer, KC7WW\n\n");


// -------------------------------------------------------------------------
//                      Find the DSP hardware 
// This is done automatically by first probing to see whether there is
// an  older  style ESC-614 ASIC (used by Cardinal, Orchid, etc.) or
// the latest style ESC-615 ASIC (used by the Echo DSP).
// -------------------------------------------------------------------------

	if (!findPSS()) {
  		printf("Sorry - can't find any DSP card\n");
  		exit(1);
		}

// -------------------------------------------------------------------------
// Reset DSP's interrupt logic, just in case it is latched on
// -------------------------------------------------------------------------
	ackInt();

// Set AD1848 for WSS simulation
	switch (DSPtype) {
		case ESC614:	
  			outpw(DSPdata + WSS_CONFIG_614, wssbase << 4);
  			break;
 		case ESC615:	
  			outpw(DSPcontrol, WSS_CONFIG_615);
  			outpw(DSPindexed, wssbase << 4);
  			break;
 		default:
         		printf("Sorry - unknown type of card\n");
	 		exit(0);
		}

// -------------------------------------------------------------------------
// Perform the DSP bootstrap next
// and verify that it has completed successfully
// -------------------------------------------------------------------------
	bootDSP(MON, 1);  // Boot kernel with hard reset

	checkdsptestprog();

// -------------------------------------------------------------------------
// Finally we are ready to load and run the DSP application
// also start the timer
// -------------------------------------------------------------------------
	start_application(APP, initstate);
	timer_test();
	terminate_application();
}

//---------------------------------------------------------------------------
//                    Some local functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Start application
//---------------------------------------------------------------------------
void start_application(char *app_name, unsigned char ad1848_state[])
{

	load_DSP_mem(app_name);	   // load the DSP application code

	set1848state(ad1848_state); // reprogram CODEC

	outp(wssbase+WSS_CODECINDEXADDR,0x0009); // Capture/Playback on
	outp(wssbase+WSS_CODECINDEXDATA,0x0003); 

	putdspword(0x00b4);        // send "start application" code to DSP 

}

//---------------------------------------------------------------------------
// Terminate application
//---------------------------------------------------------------------------
void terminate_application()
{

	putdspword(0x00b5);	// send "stop application" code to DSP

	outp(wssbase+WSS_CODECINDEXDATA,0x0009); // Playback/capture off 
	outp(wssbase+WSS_CODECINDEXDATA, 0);

	outp(wssbase+WSS_CODECINDEXADDR,0x0006);  // mute DAC
	outp(wssbase+WSS_CODECINDEXDATA, 0xDF);
	outp(wssbase+WSS_CODECINDEXADDR,0x0007);
	outp(wssbase+WSS_CODECINDEXDATA, 0xDF);

}

//--------------------------------------------------------------------------
// Timer test using interrupt IRQ7
//--------------------------------------------------------------------------
void timer_test()
{

// Define ISR prototypes
void interrupt (*oldfunc)(...);		// for storage of old vector
void interrupt DSP_int_serv(...);  	// Prototype for new interrupt serv.
unsigned char old_IMR;			// Save old PIC IMR

	tick=0;
	printf("Timer is now ticking - hit any key to stop application\n ");

	oldfunc=getvect(INT_7);		// Hook IRQ7 on the PC side
	setvect(INT_7, DSP_int_serv);

// Set INT7 on DSP side as well
	switch (DSPtype) {
		case ESC614:	
			outpw(DSPdata+PSS_CONFIG_614,IRQ7);
  			break;
 		case ESC615:	
  			outpw(DSPcontrol, 1);		// #1=CONFIGURATION
  			outpw(DSPindexed, IRQ7);
  			break;
		}


//
// This is how we arm IRQ 7 on the PC's PIC
// IRQ 7 is the MSB of the interrup mask register (IMR)
//
	old_IMR=inp(0x21);		// get IMR
	outp(0x21,old_IMR&0x7F);

	putdspword(0x00b0);		// send "start timer" code to DSP

// Show timer ticks, check when user quits 
	for(;;) {
		if(kbhit()) break;
		if(tick) {
			printf(".");
			tick=0;
			}
		}

//
// The user has indicated to stop the application
// Now we clean up in an orderly fashion
//
	getch();			// flush out breakout charater

	putdspword(0x00b1);         	// send "stop timer" code to DSP

	ackInt();			// Clear any pending PSA interrupts

	switch (DSPtype) {
		case ESC614:	
			outpw(DSPdata+PSS_CONFIG_614,NOIRQ);
  			break;
 		case ESC615:	
  			outpw(DSPcontrol, 1);		// #1=CONFIGRATION
  			outpw(DSPindexed, 0);
  			break;
		}

	outp(0x21,old_IMR);		// Restore IMR
	setvect(INT_7, oldfunc);	// Restore INT

	printf("\nApplication terminated\n");
}	

//--------------------------------------------------------------------------
// The new IRQ7 interrupt handler
//--------------------------------------------------------------------------
void interrupt DSP_int_serv(...)
{
	ackInt();			// Acknowledge interrupt
	outp(0x20,0x20); 		// write EOI to PIC 
					// else bad things happen!
	tick++;
}


