#include <exec/types.h>
#include <exec/tasks.h>
#include <libraries/dosextens.h>
#include <functions.h>
#include <string.h>

char *pathoflock(struct FileLock *l);

main(int argc, char **argv)
{
    struct CommandLineInterface *cli;
    struct Process *p;
    struct FileLock *oldlock, *lock;
    long s, l, *lp;
    char buf[256];

    p = (struct Process *)FindTask(0);
    if (!(cli = (struct CommandLineInterface *)((long)p->pr_CLI << 2)))
	exit(1);

    argc--; argv++;
    for (;argc; argc--, argv++) {
	if (s = LoadSeg(*argv)) {
	    UnLoadSeg(s);
	    puts(*argv);
	}
	l = (long) cli->cli_CommandDir;
	while (l) {
	    l <<= 2;
	    lp = (long *)l;
	    lock = (struct FileLock *)*(lp + 1);
	    oldlock = (struct FileLock *)CurrentDir(lock);
	    s = LoadSeg(*argv);
	    CurrentDir(oldlock);
	    if (s) {
		UnLoadSeg(s);
		strcpy(buf, pathoflock(lock));
		if (buf[strlen(buf) - 1] != ':')
		    strcat(buf, "/");
		strcat(buf, *argv);
		puts(buf);
	    }
	    l = *lp;
	}
	strcpy(buf, "c:");
	strcat(buf, *argv);
	if (s = LoadSeg(buf)) {
	    UnLoadSeg(s);
	    puts(buf);
	}    
    }
    exit(0);
}

char *pathoflock(struct FileLock *origl)
{
    static char tmp[256],path[256];
    struct FileInfoBlock *fib;
    struct FileLock *l, *p = origl;

    path[0] = '\0';
    fib = (struct FileInfoBlock *)malloc(sizeof(*fib));
    while (l = p) {
	Examine((BPTR)l, (BPTR)fib);
	if (!*(fib->fib_FileName))
	    strcpy(tmp, "RAM");		/* If null name, assume RAM disk */
	else
	    strcpy(tmp, (char *)(fib->fib_FileName));

	if (!(p = ParentDir(l)))
	    strcat(tmp, ":");
	else if (path[0])
	    strcat(tmp, "/");
	if (l != origl)
	    UnLock((BPTR)l);
	strcat (tmp, path);
	strcpy (path, tmp);
    }
    free(fib);
    return(path);
}
