#include <libraries/dosextens.h>
#include <exec/memory.h>
#include <functions.h>
#include <stdlib.h>
#include <string.h>

char *pathoflock(struct FileLock *l);

/* Walk up the ParentDir tree, saving the names and tacking the path already
   collected onto the end of the current node.
*/
main()
{
    struct FileLock *l;
    puts(pathoflock(l = (struct FileLock *)Lock("", ACCESS_READ)));
    UnLock((BPTR)l);
}

char *pathoflock(struct FileLock *origl)
{
    static char tmp[256],path[256];
    struct FileInfoBlock *fib;
    struct FileLock *l, *p = origl;

    path[0] = '\0';
    fib = (struct FileInfoBlock *)malloc(sizeof(*fib));
    while (l = p) {
	Examine((BPTR)l, (BPTR)fib);
	if (!*(fib->fib_FileName))
	    strcpy(tmp, "RAM");		/* If null name, assume RAM disk */
	else
	    strcpy(tmp, (char *)(fib->fib_FileName));

	if (!(p = ParentDir(l)))
	    strcat(tmp, ":");
	else if (path[0])
	    strcat(tmp, "/");
	if (l != origl)
	    UnLock((BPTR)l);
	strcat (tmp, path);
	strcpy (path, tmp);
    }
    free(fib);
    return(path);
}
