/* Amiga echo command.

   Unix->Amiga pathname alteration:

	Translates ".", "..", "./" and "../" into Amiga parlance.

*/

#include <stdio.h>
#include <string.h>

#ifdef GLOB
#define FILE_END '\n'
#else
#define FILE_END ' '
#endif

main(int argc, char **argv)
{
    char **cpp, **cppo, **wildexpand();
    int newline = 1;

    argc--; argv++;
#ifndef GLOB
    if (argc > 0 && !strcmp(*argv, "-n")) {
	newline = 0;
	argc--;	argv++;
    }
#endif
    for (; argc-- > 0; argv++) {
	amigaizepath(*argv);
	if (!(cppo = wildexpand(*argv)) || !strcmp(*argv, *cppo)) {
	    /* Print unmatched wildcard if "echo", or if exact file exists */
#ifdef GLOB
	    if (access(*argv, 0)) {	/* If file doesn't exist */
		if (argc <= 0) newline = 0;
		continue;
	    }
#endif
	    fputs(*argv, stdout);
	    if (argc > 0) putchar(FILE_END);
	} else {
	    for (cpp = cppo; *cpp; cpp++) {
		if (cpp != cppo) putchar (FILE_END);
		fputs(*cpp, stdout);
	    }

	    if (argc > 0) putchar(FILE_END);
	}
	if (cppo)
	    wildfree(cppo);
    }
    if (newline) putchar('\n');
    exit(0);
}
