#include <libraries/dosextens.h>
#include <exec/memory.h>
#include <stdarg.h>
#include <functions.h>

long send_packet (struct MsgPort *msgp, long type, ...)
{
    va_list varg;
    struct MsgPort *reply;
    struct StandardPacket *pkt;
    long rtn = 0;

    if (reply = (struct MsgPort *)CreatePort(0, 0)) {
	if (pkt = AllocMem(sizeof(*pkt), MEMF_PUBLIC|MEMF_CLEAR)) {
	    pkt->sp_Msg.mn_Node.ln_Name = (char *)&(pkt->sp_Pkt);
	    pkt->sp_Pkt.dp_Link = &(pkt->sp_Msg);
	    pkt->sp_Pkt.dp_Port = reply;
	    pkt->sp_Pkt.dp_Type = type;

	    va_start(varg, type);
	    pkt->sp_Pkt.dp_Arg1 = va_arg(varg, long);
	    pkt->sp_Pkt.dp_Arg2 = va_arg(varg, long);
	    pkt->sp_Pkt.dp_Arg3 = va_arg(varg, long);
	    pkt->sp_Pkt.dp_Arg4 = va_arg(varg, long);
	    pkt->sp_Pkt.dp_Arg5 = va_arg(varg, long);
	    pkt->sp_Pkt.dp_Arg6 = va_arg(varg, long);
	    pkt->sp_Pkt.dp_Arg7 = va_arg(varg, long);
	    va_end(arg)

	    PutMsg(msgp, &(pkt->sp_Msg));
	    WaitPort(reply);
	    GetMsg(reply);

	    rtn = pkt->sp_Pkt.dp_Res1;
            FreeMem(pkt, sizeof(*pkt));
	}
	DeletePort(reply);
    }
    return (rtn);
}
