/* mkdir shows up in fcntl.h as "int mkdir(char *name)", no mode.  The damn
   thing is undocumented in the Manx manual.  Great, an undocumented function
   screws up the compile.

   So what I did was to fix the declaration in fcntl.h.
*/
#include <libraries/dosextens.h>
#include <errno.h>
#include <functions.h>

int mkdir(char *name, int mode)
{
    BPTR lock;
    int err;

    if (!name) {
	errno = EINVAL;
	return (-1);
    }
    if (!*name) return (0);		/* "" == Current Dir */
    if (lock = Lock(name, ACCESS_READ)) {
	UnLock(lock);
	errno = EEXIST;
	return(-1);
    }
    if (lock = CreateDir(name)) {
	UnLock(lock);
	/* chmod performs the Unix->Amiga mode bit translation */
	return(chmod(name, mode));
    } else {
	err = IoErr();
	/* This is probably overkill, since it is done in no other file/dir
	   creation function.  Later I'll do something with it.
	*/
	switch (err) {
	    case ERROR_INVALID_COMPONENT_NAME:
		errno = ENOENT;
		break;
	    case ERROR_DISK_FULL:
		errno = ENOSPC;
		break;
	    case ERROR_WRITE_PROTECTED:
		errno = EACCES;
		break;
	    case ERROR_NO_DEFAULT_DIR:
	    case ERROR_ACTION_NOT_KNOWN:
		errno = EINVAL;
		break;
	    case ERROR_DISK_WRITE_PROTECTED:
		errno = EROFS;
		break;
	    case ERROR_DISK_NOT_VALIDATED:
	    default:
		errno = EIO;
		break;
	}
	return(-1);
    }
}
