/* config.h	1 May 1990 David G. Grubbs (-dgg-)

   Handcrafted from a copy of config_h.SH to work with Manx 5.0 on the Amiga

*/

/* From here to the comment starting with '%%%' are specific to the Amiga.
   I could have defined another .h file, but it would have to be included
   here.  Since this file was handcrafted anyway, why bother?  -dgg-
*/

/* The compiler defines these, but what the hell */
#ifndef AMIGA
#define AMIGA
#endif
#ifndef amiga
#define amiga
#endif

/* Since the setuid concept doesn't exist (in fact "owner" doesn't exist)
   in AmigaDOS there should be no code referring to them at all.  STIFLE_TAINT
   seems to excise some of the SUID code.
*/
#define STIFLE_TAINT

/* Manx fcntl.h defines "mkdir" with only one argument.  You
   may need to remove it to get PERL to compile.
*/
int mkdir(char *_name, int mode);

/* Not really needed, but it keeps more base code from being modified */
#define htons(a) (a)
#define htonl(a) (a)
#define ntohs(a) (a)
#define ntohl(a) (a)

#define TMPPATH "ram:perl-eXXXXXXXXX"

int syscall (long arg0, ...);

/* The rest of these are UNIX functions I have either excised specifically
   or have provided an equivalent function.
*/
/* chown is stubbed out and does nothing */
#define CHOWN
/* getlogin returns "USER" from the environment */

#define GETLOGIN
extern char *getlogin();

/* getppid returns '1' */
#define GETPPID

/* chroot has no analogue and is not used internally */
#undef CHROOT

/* link has no analogue and is used internally only if "rename" is undefined */
#undef LINK

/* Kill turns into the emasculated "break" available on the Amiga.  A true
   kill that handled -9 would require duplicating the "nuke" function of GOMF.
   Anyone want to provide one?
*/
#define KILL

/* if umask is really supposed to affect the code, I would have to rewrite
   the "open" and "mkdir" routines.  Later.  For now, just handle the
   arguments properly without affecting anything.
*/
#define UMASK

/* No such thing as groups. */
#undef GROUP

/* No passwd file either. */
#undef PASSWD

/* We use the AmigaDOS PIPE: device.  It is somewhat limited, but it allows
   us to implement the "pipe()" function.  And the "exec" code even allows
   inheritance of the file descriptors.  On the other hand, stdio is NOT
   inherited, since the data areas are not copied.  Use fflush().
*/
#define PIPE

/* Not yet -- if ever.  Straight "Fork" is hard on the Amiga */
#undef FORK
/* There is a wait, but it doesn't do what you think it does. */
#undef WAIT

/* %%%%%%%%%%%%%  End of Amiga-specific section */


/* EUNICE:
 *	This symbol, if defined, indicates that the program is being compiled
 *	under the EUNICE package under VMS.  The program will need to handle
 *	things like files that don't go away the first time you unlink them,
 *	due to version numbering.  It will also need to compensate for lack
 *	of a respectable link() command.
 */
/* VMS:
 *	This symbol, if defined, indicates that the program is running under
 *	VMS.  It is currently only set in conjunction with the EUNICE symbol.
 */
#undef	EUNICE			/**/
#undef	VMS			/**/

/* BIN:
 *	This symbol holds the name of the directory in which the user wants
 *	to put publicly executable images for the package in question.  It
 *	is most often a local directory such as /usr/local/bin.
 */
#define BIN "Bin:"             /**/

/* BYTEORDER:
 *	This symbol contains an encoding of the order of bytes in a long.
 *	Usual values (in hex) are 0x1234, 0x4321, 0x2143, 0x3412...
 */
#define BYTEORDER 0x4321		/**/

/* CPPSTDIN:
 *	This symbol contains the first part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.	 Typical value of "cc -E" or "/lib/cpp".
 */
/* CPPMINUS:
 *	This symbol contains the second part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.  This symbol will have the value "-" if CPPSTDIN needs a minus
 *	to specify standard input, otherwise the value is "".
 */
#define CPPSTDIN "Bin:cpp"
#define CPPMINUS "-"

/* BCMP:
 *	This symbol, if defined, indicates that the bcmp routine is available
 *	to compare blocks of memory.  If undefined, use memcmp.  If that's
 *	not available, roll your own.
 */
#undef	BCMP			/**/

/* BCOPY:
 *	This symbol, if defined, indicates that the bcopy routine is available
 *	to copy blocks of memory.  Otherwise you should probably use memcpy().
 */
#undef	BCOPY			/**/


/* BZERO:
 *	This symbol, if defined, indicates that the bzero routine is available
 *	to zero blocks of memory.  Otherwise you should probably use memcpy().
 */
#undef	BZERO			/**/

/* CASTNEGFLOAT:
 *	This symbol, if defined, indicates that this C compiler knows how to
 *	cast negative numbers to unsigned longs, ints and shorts.
 */
#define		CASTNEGFLOAT	/**/

/* CHARSPRINTF:
 *	This symbol is defined if this system declares "char *sprintf()" in
 *	stdio.h.  The trend seems to be to declare it as "int sprintf()".  It
 *	is up to the package author to declare sprintf correctly based on the
 *	symbol.
 */
#undef		CHARSPRINTF 	/**/

/* CRYPT:
 *	This symbol, if defined, indicates that the crypt routine is available
 *	to encrypt passwords and the like.
 */
#undef		CRYPT		/**/

/* CSH:
 *	This symbol, if defined, indicates that the C-shell exists.
 *	If defined, contains the full pathname of csh.
 *	WARNING:  Unless you use an Amiga shell that acts a lot like csh,
 *	you will lose here.
 *	#define		CSH	"Bin:csh"
 */
#undef		CSH

/* DOSUID:
 *	This symbol, if defined, indicates that the C program should
 *	check the script that it is executing for setuid/setgid bits, and
 *	attempt to emulate setuid/setgid on systems that have disabled
 *	setuid #! scripts because the kernel can't do it securely.
 *	It is up to the package designer to make sure that this emulation
 *	is done securely.  Among other things, it should do an fstat on
 *	the script it just opened to make sure it really is a setuid/setgid
 *	script, it should make sure the arguments passed correspond exactly
 *	to the argument on the #! line, and it should not trust any
 *	subprocesses to which it must pass the filename rather than the
 *	file descriptor of the script to be executed.
 */
#undef		DOSUID		/**/

/* DUP2:
 *	This symbol, if defined, indicates that the dup2 routine is available
 *	to dup file descriptors.  Otherwise you should use dup().
 */
#define	DUP2

/* ENVIRON
 *	This symbol, if defined, indicates that Environment variables are
 *	normal.  If this is *not* defined, the environment may only be handled
 *	only by the "setenv" and "getenv" routines provided by the system or
 *	by custom functions linked in from a library and no assumptions about
 *	the use (or existence) of "extern char **environ" may be made.
 */
#undef ENVIRON

/* FCHMOD:
 *	This symbol, if defined, indicates that the fchmod routine is available
 *	to change mode of opened files.  If unavailable, use chmod().
 */
#undef	FCHMOD		/**/

/* FCHOWN:
 *	This symbol, if defined, indicates that the fchown routine is available
 *	to change ownership of opened files.  If unavailable, use chown().
 */
#undef	FCHOWN		/**/

/* FCNTL:
 *	This symbol, if defined, indicates we have an fcntl function.
 */
#undef		FCNTL		/**/

/* FLOCK:
 *	This symbol, if defined, indicates that the flock() routine is
 *	available to do file locking.
 */
#undef	FLOCK		/**/

/* GETGROUPS:
 *	This symbol, if defined, indicates that the getgroups() routine is
 *	available to get the list of process groups.  If unavailable, multiple
 *	groups are probably not supported.
 */
#undef	GETGROUPS		/**/

/* GETHOSTENT:
 *	This symbol, if defined, indicates that the gethostent() routine is
 *	available to lookup host names in some data base or other.
 */
#undef	GETHOSTENT		/**/

/* GETPGRP:
 *	This symbol, if defined, indicates that the getpgrp() routine is
 *	available to get the current process group.
 */
#undef	GETPGRP		/**/

/* GETPGRP2:
 *	This symbol, if defined, indicates that the getpgrp2() (as in DG/UX)
 *	routine is available to get the current process group.
 */
#undef	GETPGRP2		/**/

/* GETPRIORITY:
 *	This symbol, if defined, indicates that the getpriority() routine is
 *	available to get a process's priority.
 */
#undef	GETPRIORITY		/**/

/* HTONS:
 *	This symbol, if defined, indicates that the htons routine (and friends)
 *	are available to do network order byte swapping.
 */
/* HTONL:
 *	This symbol, if defined, indicates that the htonl routine (and friends)
 *	are available to do network order byte swapping.
 */
/* NTOHS:
 *	This symbol, if defined, indicates that the ntohs routine (and friends)
 *	are available to do network order byte swapping.
 */
/* NTOHL:
 *	This symbol, if defined, indicates that the ntohl routine (and friends)
 *	are available to do network order byte swapping.
 */
#undef	HTONS		/**/
#undef	HTONL		/**/
#undef	NTOHS		/**/
#undef	NTOHL		/**/

/* index:
 *	This preprocessor symbol is defined, along with rindex, if the system
 *	uses the strchr and strrchr routines instead.
 */
/* rindex:
 *	This preprocessor symbol is defined, along with index, if the system
 *	uses the strchr and strrchr routines instead.
 */
#define	index strchr	/* cultural */
#define	rindex strrchr	/*  differences? */

/* IOCTL:
 *	This symbol, if defined, indicates that sys/ioctl.h exists and should
 *	be included.
 */
#undef	IOCTL		/**/

/* KILLPG:
 *	This symbol, if defined, indicates that the killpg routine is available
 *	to kill process groups.  If unavailable, you probably should use kill
 *	with a negative process number.
 */
#undef	KILLPG		/**/

/* LSTAT:
 *	This symbol, if defined, indicates that the lstat() routine is
 *	available to do file locking.
 */
#undef	LSTAT		/**/

/* MEMCMP:
 *	This symbol, if defined, indicates that the memcmp routine is available
 *	to compare blocks of memory.  If undefined, roll your own.
 */
#define	MEMCMP		/**/

/* MEMCPY:
 *	This symbol, if defined, indicates that the memcpy routine is available
 *	to copy blocks of memory.  Otherwise you should probably use bcopy().
 *	If neither is defined, roll your own.
 */
#define	MEMCPY		/**/

/* MKDIR:
 *	This symbol, if defined, indicates that the mkdir routine is available
 *	to create directories.  Otherwise you should fork off a new process to
 *	exec /bin/mkdir.
 */
#define	MKDIR		/**/

/* NDBM:
 *	This symbol, if defined, indicates that ndbm.h exists and should
 *	be included.
 */
#undef	NDBM		/**/

/* ODBM:
 *	This symbol, if defined, indicates that dbm.h exists and should
 *	be included.
 */
#undef	ODBM		/**/

/* READDIR:
 *	This symbol, if defined, indicates that the readdir routine is
 *	available from the C library to read directories.
 */
#define	READDIR		/**/

/* RENAME:
 *	This symbol, if defined, indicates that the rename routine is available
 *	to rename files.  Otherwise you should do the unlink(), link(),
 *	unlink() trick.
 */
#define	RENAME		/**/

/* RMDIR:
 *	This symbol, if defined, indicates that the rmdir routine is available
 *	to remove directories.  Otherwise you should fork off a new process to
 *	exec /bin/rmdir.
 */
#define	RMDIR		/**/

/* SETEGID:
 *	This symbol, if defined, indicates that the setegid routine is
 *	available to change the effective gid of the current program.
 */
#undef	SETEGID		/**/

/* SETEUID:
 *	This symbol, if defined, indicates that the seteuid routine is
 * 	available to change the effective uid of the current program.
 */
#undef	SETEUID		/**/

/* SETPGRP:
 *	This symbol, if defined, indicates that the setpgrp() routine is
 *	available to set the current process group.
 */
#undef	SETPGRP		/**/

/* SETPGRP2:
 *	This symbol, if defined, indicates that the setpgrp2() (as in DG/UX)
 *	routine is available to set the current process group.
 */
#undef	SETPGRP2		/**/

/* SETPRIORITY:
 *	This symbol, if defined, indicates that the setpriority() routine is
 *	available to set a process's priority.
 */
#undef	SETPRIORITY		/**/

/* SETREGID:
 *	This symbol, if defined, indicates that the setregid routine is
 *	available to change the real and effective gid of the current program.
 */
/* SETRESGID:
 *	This symbol, if defined, indicates that the setresgid routine is
 *	available to change the real, effective and saved gid of the current
 *	program.
 */
#undef	SETREGID		/**/
#undef	SETRESGID		/**/

/* SETREUID:
 *	This symbol, if defined, indicates that the setreuid routine is
 *	available to change the real and effective uid of the current program.
 */
/* SETRESUID:
 *	This symbol, if defined, indicates that the setresuid routine is
 *	available to change the real, effective and saved uid of the current
 *	program.
 */
#undef	SETREUID		/**/
#undef	SETRESUID		/**/

/* SETRGID:
 *	This symbol, if defined, indicates that the setrgid routine is
 *	available to change the real gid of the current program.
 */
#undef	SETRGID		/**/

/* SETRUID:
 *	This symbol, if defined, indicates that the setruid routine is
 *	available to change the real uid of the current program.
 */
#undef	SETRUID		/**/

/* SOCKET:
 *	This symbol, if defined, indicates that the BSD socket interface is
 *	supported.
 */
/* SOCKETPAIR:
 *	This symbol, if defined, indicates that the BSD socketpair call is
 *	supported.
 */
/* OLDSOCKET:
 *	This symbol, if defined, indicates that the 4.1c BSD socket interface
 *	is supported instead of the 4.2/4.3 BSD socket interface.
 */
#undef	SOCKET		/**/

#undef	SOCKETPAIR	/**/

#undef	OLDSOCKET	/**/

/* STATBLOCKS:
 *	This symbol is defined if this system has a stat structure declaring
 *	st_blksize and st_blocks.
 */
#define	STATBLOCKS 	/**/

/* STDSTDIO:
 *	This symbol is defined if this system has a FILE structure declaring
 *	_ptr and _cnt in stdio.h.
 */
#undef	STDSTDIO 	/**/

/* STRUCTCOPY:
 *	This symbol, if defined, indicates that this C compiler knows how
 *	to copy structures.  If undefined, you'll need to use a block copy
 *	routine of some sort instead.
 */
#define	STRUCTCOPY	/**/

/* STRERROR:
 *	This symbol, if defined, indicates that the strerror() routine is
 *	available to translate error numbers to strings.
 */
#define	STRERROR		/**/

/* SYMLINK:
 *	This symbol, if defined, indicates that the symlink routine is
 *	available to create symbolic links.
 */
#undef	SYMLINK		/**/

/* SYSCALL:
 *	This symbol, if defined, indicates that the syscall routine is
 *	available to call arbitrary system calls.  If undefined, that's tough.
 */
#define	SYSCALL		/**/

/* VARARGS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include varargs.h.
 */
#undef	VARARGS		/**/

/* VFORK:
 *	This symbol, if defined, indicates that vfork() exists.
 */
#undef	VFORK	/**/

/* VOIDSIG:
 *	This symbol is defined if this system declares "void (*signal())()" in
 *	signal.h.  The old way was to declare it as "int (*signal())()".  It
 *	is up to the package author to declare things correctly based on the
 *	symbol.
 */
#define	VOIDSIG 	/**/

/* HASVOLATILE:
 *	This symbol, if defined, indicates that this C compiler knows about
 *	the volatile declaration.
 */
#define	HASVOLATILE	/**/

/* VPRINTF:
 *	This symbol, if defined, indicates that the vprintf routine is
 *	available to printf with a pointer to an argument list.  If
 *	unavailable, you may need to write your own, probably in terms of
 *	_doprnt().
 */
/* CHARVSPRINTF:
 *	This symbol is defined if this system has vsprintf() returning type
 *	(char*).  The trend seems to be to declare it as "int vsprintf()".  It
 *	is up to the package author to declare vsprintf correctly based on the
 *	symbol.
 */
#define	VPRINTF		/**/
#define	CHARVSPRINTF 	/**/

/* WAIT4:
 *	This symbol, if defined, indicates that wait4() exists.
 */
#undef	WAIT4	/**/

/* GIDTYPE:
 *	This symbol has a value like gid_t, int, ushort, or whatever type is
 *	used to declare group ids in the kernel.
 */
#define GIDTYPE int		/**/

/* I_DIRENT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include dirent.h.
 */
/* DIRNAMLEN:
 *	This symbol, if defined, indicates to the C program that the length
 *	of directory entry names is provided by a d_namlen field.  Otherwise
 *	you need to do strlen() on the d_name field.
 */
#undef	I_DIRENT		/**/
#undef	DIRNAMLEN		/**/

/* I_FCNTL:
 *	This symbol, if defined, indicates to the C program that it should
 *	include fcntl.h.
 */
#define	I_FCNTL		/**/

/* I_GRP:
 *	This symbol, if defined, indicates to the C program that it should
 *	include grp.h.
 */
#undef	I_GRP		/**/

/* I_NETINET_IN:
 *	This symbol, if defined, indicates to the C program that it should
 *	include netinet/in.h.
 */
#undef	I_NETINET_IN		/**/

/* I_PWD:
 *	This symbol, if defined, indicates to the C program that it should
 *	include pwd.h.
 */
/* PWQUOTA:
 *	This symbol, if defined, indicates to the C program that struct passwd
 *	contains pw_quota.
 */
/* PWAGE:
 *	This symbol, if defined, indicates to the C program that struct passwd
 *	contains pw_age.
 */
/* PWCHANGE:
 *	This symbol, if defined, indicates to the C program that struct passwd
 *	contains pw_change.
 */
/* PWCLASS:
 *	This symbol, if defined, indicates to the C program that struct passwd
 *	contains pw_class.
 */
/* PWEXPIRE:
 *	This symbol, if defined, indicates to the C program that struct passwd
 *	contains pw_expire.
 */
#undef	I_PWD		/**/
#undef	PWQUOTA		/**/
#undef	PWAGE		/**/
#undef	PWCHANGE	/**/
#undef	PWCLASS		/**/
#undef	PWEXPIRE	/**/

/* I_SYSPARAM:
 *	This symbol is defined if the program should include <sys/param.h>.
 */
#undef I_SYSPARAM

/* I_STAT:
 *	This symbol is defined if the program should include "stat.h".
 */
/* I_SYSSTAT:
 *	This symbol is defined if the program should include <sys/stat.h>.
 */
#define I_STAT
#undef I_SYSSTAT

/* I_DIR:
 *	This symbol, if defined, indicates to the C program that it should
 *	include "dir.h".
 */
/* I_SYSDIR:
 *	This symbol, if defined, indicates to the C program that it should
 *	include sys/dir.h.
 */
/* I_SYSNDIR:
 *	This symbol, if defined, indicates to the C program that it should
 *	include sys/ndir.h.
 */

#define	I_DIR		/**/
#undef	I_SYSDIR		/**/
#undef	I_SYSNDIR		/**/

/* I_SGTTY:
 *	This symbol, if defined, indicates to the C program that it should
 *	include sgtty.h
 */
#define	I_SGTTY		/**/

/* I_SYSIOCTL:
 *	This symbol, if defined, indicates that sys/ioctl.h exists and should
 *	be included.
 */
#undef	I_SYSIOCTL		/**/

/* I_TIME:
 *	This symbol is defined if the program should include <time.h>.
 */
/* I_SYSTIME:
 *	This symbol is defined if the program should include <sys/time.h>.
 */
/* I_SYSTIMEKERNEL:
 *	This symbol is defined if the program should include <sys/time.h>
 *	with KERNEL defined.
 */
#define		I_TIME	 	/**/
#undef	I_SYSTIME 	/**/
#undef	SYSTIMEKERNEL 	/**/

/* I_SYSTIMES:
 *	This symbol, if defined, indicates to the C program that it should
 *	include sys/times.h.
 */
#undef I_SYSTIMES

/* I_SYSTYPES:
 *	This symbol, if defined, indicates to the C program that it should
 *	include sys/types.h
 */
#undef I_SYSTYPES	/**/

/* I_UTIME:
 *	This symbol, if defined, indicates to the C program that it should
 *	include utime.h.
 */
#undef	I_UTIME		/**/

/* I_VARARGS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include varargs.h.
 */
#undef	I_VARARGS		/**/

/* I_VFORK:
 *	This symbol, if defined, indicates to the C program that it should
 *	include vfork.h.
 */
#undef	I_VFORK		/**/

/* INTSIZE:
 *	This symbol contains the size of an int, so that the C preprocessor
 *	can make decisions based on it.
 */
#define INTSIZE 4		/**/

/* RANDBITS:
 *	This symbol contains the number of bits of random number the rand()
 *	function produces.  Usual values are 15, 16, and 31.
 */
#define RANDBITS 15		/**/

/* SIG_NAME:
 *	This symbol contains an list of signal names in order.
 */
#define SIG_NAME "SIGINT","SIGTERM", "SIGABRT","SIGFPE", "SIGILL","SIGSEGV"

/* STDCHAR:
 *	This symbol is defined to be the type of char used in stdio.h.
 *	It has the values "unsigned char" or "char".
 */
#define STDCHAR unsigned char	/**/

/* UIDTYPE:
 *	This symbol has a value like uid_t, int, ushort, or whatever type is
 *	used to declare user ids in the kernel.
 */
#define UIDTYPE int		/**/

/* VOIDFLAGS:
 *	This symbol indicates how much support of the void type is given by
 *	this compiler.  What various bits mean:
 *
 *	    1 = supports declaration of void
 *	    2 = supports arrays of pointers to functions returning void
 *	    4 = supports comparisons between pointers to void functions and
 *		    addresses of void functions
 *
 *	The package designer should define VOIDUSED to indicate the
 *	requirements of the package.  This can be done either by #defining
 *	VOIDUSED before including config.h, or by defining defvoidused in
 *	Myinit.U.  If the latter approach is taken, only those flags will be
 *	tested.  If the level of void support necessary is not present,
 *	defines void to int.
 */
#ifndef VOIDUSED
#define VOIDUSED 7
#endif
#define VOIDFLAGS 7
#if (VOIDFLAGS & VOIDUSED) != VOIDUSED
#define void int		/* is void to be avoided? */
#define M_VOID		/* Xenix strikes again */
#endif

/* PRIVLIB:
 *	This symbol contains the name of the private library for this package.
 *	The library is private in the sense that it needn't be in anyone's
 *	execution path, but it should be accessible by the world.  The program
 *	should be prepared to do ~ expansion.
 */
#define PRIVLIB "s:perl"		/**/
