#include <libraries/dosextens.h>
#include <errno.h>
#include "stat.h"

/* Interact with "stat" in what the mode bits mean. */
int chmod (char *name, int u_mode)
{
    long a_mode = 0;

    if (!(u_mode & (S_IREAD | (S_IREAD >> 3) | (S_IREAD >> 6))))
	a_mode |= FIBF_READ;
    if (!(u_mode & (S_IWRITE | (S_IWRITE >> 3) | (S_IWRITE >> 6))))
	a_mode |= FIBF_WRITE;
    if (!(u_mode & (S_IEXEC | (S_IEXEC >> 3) | (S_IEXEC >> 6))))
	a_mode |= FIBF_EXECUTE;

    if (u_mode & S_PURE) a_mode |= FIBF_PURE;
    if (u_mode & S_SCRIPT) a_mode |= FIBF_SCRIPT;
    if (u_mode & S_ARCHIVE) a_mode |= FIBF_ARCHIVE;
    if (u_mode & S_NODELETE) a_mode |= FIBF_DELETE;

    if (SetProtection(name, a_mode)) return (0);
    errno = ENOENT;
    return(-1);
}
