 /*
  * Khoros: $Id: vmediaxis.c,v 1.1 1991/05/10 15:51:11 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmediaxis.c,v 1.1 1991/05/10 15:51:11 khoros Exp $";
#endif

 /*
  * $Log: vmediaxis.c,v $
 * Revision 1.1  1991/05/10  15:51:11  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmediaxis.c
 >>>>
 >>>>      Program Name: vmediaxis
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Computes the medial axis transform
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:39:58 1991
 >>>>
 >>>>          Routines: main- the main program for vmediaxis
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmediaxis.h"


/****************************************************************
 *
 * Routine Name:  main program for vmediaxis
 *
 *       Input:  
 *           -i  input image 
 *           -o  output image 
 *           -w  if flag=1 the medial axis has the value 255, otherwise (default) the value is the distance from the border 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int wflag;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        READINPUT(image) ;
        CHECKINPUT(program, image) ;
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvmediaxis(image,vmediaxis->w_logic))
        {
                (void) fprintf(stderr, "vmediaxis: lvmediaxis Failed\n");
                exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vmediaxis->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmediaxis 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmediaxis :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tComputes the medial axis transform\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-w  if flag=1 the medial axis has the value 255, otherwise (default) the value is the distance from the border  (boolean)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmediaxis\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmediaxis\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmediaxis.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmediaxis.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmediaxis
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) if flag=1 the medial axis has the value 255, otherwise (default) the value is the distance from the border \n        {boolean, (y/n) }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmediaxis", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmediaxis.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmediaxis: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmediaxis.ans");
		}

	     }

	}

	/*
	 * allocate the vmediaxis structure
	 */
	vmediaxis = (vmediaxis_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmediaxis_struct));

	/*
	 * get required arguments for vmediaxis
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmediaxis->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmediaxis->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmediaxis->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmediaxis->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmediaxis->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmediaxis->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmediaxis->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmediaxis->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmediaxis->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmediaxis->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmediaxis->w_flag = vget_logic(fid, prompt_flag,
			"-w", w_pstr, &(vmediaxis->w_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmediaxis->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vmediaxis->w_flag = vget_logic(fid, prompt_flag,
		    "-w", w_pstr, &(vmediaxis->w_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



