 /*
  * Khoros: $Id: vprdata.c,v 1.1 1991/05/10 15:49:52 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vprdata.c,v 1.1 1991/05/10 15:49:52 khoros Exp $";
#endif

 /*
  * $Log: vprdata.c,v $
 * Revision 1.1  1991/05/10  15:49:52  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vprdata.c
 >>>>
 >>>>      Program Name: vprdata
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	vprdata prints to a file or the screen xviff  file  data  in
 >>>>	ascii format.
 >>>>	
 >>>>	
 >>>>            Author: Mark Young, Tom Sauer, John Rasure
 >>>>
 >>>> Date Last Updated: Mon May  6 08:44:56 1991
 >>>>
 >>>>          Routines: main- the main program for vprdata
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vprdata.h"


/****************************************************************
 *
 * Routine Name:  main program for vprdata
 *
 *       Input:  
 *         -i  input image 
 *
 *
 *         [-f] output ASCII file
 *         [-m] if yes (default) print data as matrix, if no then column
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
    FILE *printdev;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT(img1) ;
/* -main_before_lib_call_end */

/* -main_library_call */
   if (vprdata->f_flag) 
   {
      if (! vwrite_ascii(vprdata->f_file, &printdev))
      {
         (void) fprintf(stderr, 
                "vprdata:  Can't open ascii output file: \n");
         exit(1);
      }
   }
   else
   printdev = stdout;
   if (! lvprdata(image, vprdata->m_logic,vprdata->i_file,printdev))
   {

      (void) fprintf(stderr, "libvprdata Failed\n");
      exit(1);
   }
/* -main_library_call_end */

/* -main_after_lib_call */
   fclose(printdev);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vprdata 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vprdata :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tvprdata prints to a file or the screen xviff  file  data  in\n");
	fprintf(stderr, "\tascii format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-f]  output ASCII file (outfile) [null]\n");
	fprintf(stderr,"\t[-m]  if yes (default) print data as matrix, if no then column (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vprdata\n");
	fprintf(stderr, "\t[-U] Gives the usage for vprdata\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vprdata.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vprdata.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vprdata
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) if yes (default) print data as matrix, if no then column \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vprdata", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vprdata.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vprdata: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vprdata.ans");
		}

	     }

	}

	/*
	 * allocate the vprdata structure
	 */
	vprdata = (vprdata_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vprdata_struct));

	/*
	 * get required arguments for vprdata
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vprdata->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vprdata->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vprdata->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vprdata->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vprdata->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vprdata
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vprdata->f_flag = vget_outfile(fid, prompt_flag,
	"-f", f_pstr, &(vprdata->f_file))
;

	vprdata->m_flag = vget_logic(fid, prompt_flag,
	"-m", m_pstr, &(vprdata->m_logic), 1);


}



