 /*
  * Khoros: $Id: vtranslat.c,v 1.1 1991/05/10 15:49:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vtranslat.c,v 1.1 1991/05/10 15:49:15 khoros Exp $";
#endif

 /*
  * $Log: vtranslat.c,v $
 * Revision 1.1  1991/05/10  15:49:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vtranslat.c
 >>>>
 >>>>      Program Name: vtranslat
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Translates an image
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Sun Mar 31 13:56:27 1991
 >>>>
 >>>>          Routines: main- the main program for vtranslat
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vtranslat.h"


/****************************************************************
 *
 * Routine Name:  main program for vtranslat
 *
 *       Input:  
 *           -i  input image 
 *           -o  resulting output image 
 *           -x  Translation along x axe  
 *           -y  Translation along y axe  
 *
 *
 *           [-w] if true, wraps the image around, if false pads with a padding value
 *           [-p] paddingvalue 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image, *readimage();
        int xt, yt;
        int wflag;
        float pad;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        READINPUT(image) ;
        CHECKINPUT(program, image) ;
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lvtranslat(image,
                         vtranslat->x_int,
                         vtranslat->y_int,
                         vtranslat->w_logic,
                         vtranslat->p_float))
        {
           (void) fprintf(stderr, "vtranslat: lvtranslat Failed\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vtranslat->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vtranslat 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vtranslat :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTranslates an image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-x  Translation along x axe  (integer)\n");
	fprintf(stderr,"\t-y  Translation along y axe  (integer)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-w]  if true, wraps the image around, if false pads with a padding value (boolean) [false]\n");
	fprintf(stderr,"\t[-p]  paddingvalue (float) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vtranslat\n");
	fprintf(stderr, "\t[-U] Gives the usage for vtranslat\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vtranslat.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vtranslat.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vtranslat
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) Translation along x axe \n        {integer}: "; 
char	*y_pstr = 
	"\nEnter: (y) Translation along y axe \n        {integer}: "; 
char	*w_pstr = 
	"\nEnter: (w) if true, wraps the image around, if false pads with a padding value \n        {boolean, (y/n)  [no] }: "; 
char	*p_pstr = 
	"\nEnter: (p) paddingvalue \n        {float [0.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vtranslat", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vtranslat.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vtranslat: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vtranslat.ans");
		}

	     }

	}

	/*
	 * allocate the vtranslat structure
	 */
	vtranslat = (vtranslat_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vtranslat_struct));

	/*
	 * get required arguments for vtranslat
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vtranslat->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vtranslat->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtranslat->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vtranslat->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vtranslat->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vtranslat->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vtranslat->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtranslat->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vtranslat->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vtranslat->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vtranslat->x_flag = vget_int(fid, prompt_flag,
			"-x", x_pstr, &(vtranslat->x_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtranslat->x_flag))
		{
		    fprintf(stderr, "\t\tx is required, please re-enter: \n");
		    vtranslat->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(vtranslat->x_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-x' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vtranslat->y_flag = vget_int(fid, prompt_flag,
			"-y", y_pstr, &(vtranslat->y_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtranslat->y_flag))
		{
		    fprintf(stderr, "\t\ty is required, please re-enter: \n");
		    vtranslat->y_flag = vget_int(fid, prompt_flag,
		    "-y", y_pstr, &(vtranslat->y_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vtranslat
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vtranslat->w_flag = vget_logic(fid, prompt_flag,
	"-w", w_pstr, &(vtranslat->w_logic), 0);

	vtranslat->p_flag = vget_float(fid, prompt_flag,
	"-p", p_pstr, &(vtranslat->p_float),
	0.000000, 0.000000, 0.000000);


}



