 /*
  * Khoros: $Id: vrmatch.h,v 1.2 1991/12/18 09:30:26 dkhoros Exp $
  */

 /*
  * $Log: vrmatch.h,v $
 * Revision 1.2  1991/12/18  09:30:26  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrmatch.h
 >>>>            Author: Pascal Adam
 >>>> Date Last Updated: Sat Dec 14 18:10:55 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vrmatch_h_
#define _vrmatch_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vrmatch Argument Structure
*
****************************************************************/

typedef struct _vrmatch  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  Input image (Required infile)
 */
char	*i2_file;	/* Input image FILENAME */
int	 i2_flag;	/* Input image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

}  vrmatch_struct;

vrmatch_struct *vrmatch;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image1,image2) \
   image1 = readimage(vrmatch->i1_file); \
   if (image1 == NULL) \
   { \
      (void) fprintf(stderr,"vrmatch: The first Image could not be read\n"); \
      exit(1); \
   } \
   image2 = readimage(vrmatch->i2_file); \
   if (image2 == NULL) \
   { \
      (void) fprintf(stderr,"vrmatch: The second Image could not be read\n"); \
      exit(1); \
   } 


#define CHECKINPUT(program, image1,image2) \
        if ((image1->data_storage_type != VFF_TYP_4_BYTE) && \
            (image2->data_storage_type != VFF_TYP_4_BYTE)) { \
            (void) fprintf(stderr,  \
"vrmatch: can't accept the data storage type of  input image!\n\n"); \
            exit(1); \
            }; \
        (void) proper_num_images(program,image1,1,TRUE); \
        (void) proper_num_bands(program,image1,1,TRUE); \
        (void) proper_map_enable(program,image1,VFF_MAP_OPTIONAL,TRUE); \
        (void) proper_num_images(program,image2,1,TRUE); \
        (void) proper_num_bands(program,image2,1,TRUE); \
        (void) proper_map_enable(program,image2,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
