 /*
  * Khoros: $Id: vrtoc.h,v 1.2 1992/03/20 22:53:24 dkhoros Exp $
  */

 /*
  * $Log: vrtoc.h,v $
 * Revision 1.2  1992/03/20  22:53:24  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrtoc.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Mar  9 19:30:15 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vrtoc_h_
#define _vrtoc_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vrtoc Argument Structure
*
****************************************************************/

typedef struct _vrtoc  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  input image (Optional infile)
 */
char	*i2_file;	/* input image FILENAME */
int	 i2_flag;	/* input image FLAG */

/*
 * Choose the type of conversion from real to complex (Optional integer toggle - )
 */
int	 t_toggle;		/* Choose the type of conversion from real to complex INT TOGGLE */
int	 t_flag;		/* Choose the type of conversion from real to complex FLAG */

}  vrtoc_struct;

vrtoc_struct *vrtoc;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        if (propertype(program,image,VFF_TYP_COMPLEX,FALSE) || \
            propertype(program,image,VFF_TYP_BIT,FALSE)) \
        { \
            (void) fprintf(stderr, "Input image: Image data type can \
NOT be COMPLEX || BIT\n"); \
            exit(1); \
        }

#define MATCHINPUT(program, img1, img2) \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) match_num_bands(program,img1,img2,TRUE); \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
