 /*
  * Khoros: $Id: mlse.c,v 1.2 1992/03/20 23:45:33 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: mlse.c,v 1.2 1992/03/20 23:45:33 dkhoros Exp $";
#endif

 /*
  * $Log: mlse.c,v $
 * Revision 1.2  1992/03/20  23:45:33  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: mlse.c
 >>>>
 >>>>      Program Name: mlse
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	solves a system of linear equations
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley, Salah Al-Daragmi, Johnny Pino, Matt Lawrence, Ken Downs
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:51:58 1992
 >>>>
 >>>>          Routines: main- the main program for mlse
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "mlse.h"


/****************************************************************
 *
 * Routine Name:  main program for mlse
 *
 *       Input:  
 *      -i1  coefficient matrix 
 *      -i2  vector matrix 
 *      -o  resulting output matrix 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   struct xvimage *image1,*image2,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image1 = readimage(mlse->i1_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image1,1,TRUE);

  if((image2 = readimage(mlse->i2_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image2,1,TRUE);
  (void)match_num_bands(program,image1,image2,TRUE);
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lmlse(image1,image2)) {
     (void)fprintf(stderr, "%s: lmlse failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  if(mlse->o_flag){
     if(!(writeimage(mlse->o_file,image1))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
              program);
        exit(1);
     }
  }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for mlse 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "mlse :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tsolves a system of linear equations\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  coefficient matrix  (infile)\n");
	fprintf(stderr,"\t-i2  vector matrix  (infile)\n");
	fprintf(stderr,"\t-o  resulting output matrix  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for mlse\n");
	fprintf(stderr, "\t[-U] Gives the usage for mlse\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called mlse.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses mlse.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for mlse
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) coefficient matrix \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) vector matrix \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output matrix \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "mlse", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "mlse.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "mlse: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "mlse.ans");
		}

	     }

	}

	/*
	 * allocate the mlse structure
	 */
	mlse = (mlse_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (mlse_struct));

	/*
	 * get required arguments for mlse
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(mlse->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(mlse->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlse->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    mlse->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(mlse->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mlse->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(mlse->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlse->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    mlse->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(mlse->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mlse->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(mlse->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlse->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    mlse->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(mlse->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



