/* ** lvr_io.c ** */
/* #define DEBUG_IO      /* define to display bytes to/from lvr */
/* input_1_byte()     - input 1 byte from lvr, print hex and ascii for byte
/*                      if a return code, print return
/* input_byte()       - input 1 byte, returning byte and putting in g_return
/* empty_input()      - empty any garbage in lvr input buffer
/* input_bytes()      - either get bytes of input until a COMPLETEION character
/*                      of non-ACK return character 
/*                        OR
/*                    - get specified # of bytes
/* ouput_cmds()       - output a commands and parameters to lvr and get back 
                        ACK and any expected COMPLETION codes
/* setup_tty()        - device setup
/* more_setup_tty()   - more device setup 
 */
#include <stdio.h>
#include <time.h>
#ifndef vms
#include <sys/time.h>
#endif
#include "lvr_defines.h"


#ifdef vms
#define OK 1
#define if_fail_die(p1) if (((status = p1) & OK) != OK){ LIB$SIGNAL(status); \
   exit(1); }
#include descrip
#include ssdef
#include iodef
#include ttdef

   static int status;  
   static unsigned short chan;   /* channel of lvr device */
   static struct char_buf        /* original lvr device characteristics buffer */
      {
      unsigned char class;
      unsigned char type;
      unsigned short buffer_size;
      unsigned char charac[3];
      unsigned char page;
      } orig;
   static char ctr_dev[100];
   static $DESCRIPTOR(ctr_dev_desc, ctr_dev);

#else   /* Unix */
   static FILE *ifile, *ofile;
   static int ifile_d;
#endif /* vms else unix */


   static int g_cmd =0;
   static int g_enter=0;
   static int g_return_code;


/* ***  */
   struct code_struct
      {
      int code;
      char *mesg;
      };

   static struct code_struct returns[] =
       { { ACK,"ACK"},
	 { COMPLETION,"COMPLETION"},
	 { ERROR,"ERROR"},
	 { LID_OPEN,"LID_OPEN"},
	 { MARK_RETURN, "MARK RETURN"},
	 { NAK, "NAK"},
	 { NO_FRAME_NUMBER, "NO FRAME NUMBER"},
	 { NOT_TARGET,"NOT TARGET"},
	 { USER_INTERRUPT,"USER INTERRUPT"}  };     

   static num_returns = sizeof(returns)/ sizeof(struct code_struct);

   struct code_struct_2
     {
     int code;
     int num_enter;
     char *mesg;
     };

   static struct code_struct_2 completes[] =
       { { SEARCH,1,"SEARCH"},
	 /* {	REPEAT,2,"REPEAT"},   ...or 3 sometimes */
	 { REC_STANDBY,0,"REC STANDBY"}, /* 2 completes -after cmd & after params*/
	 { REC,0,"REC"},
	 { EDGE_RIGHT,0,"EDGE RIGHT"},
	 { EDGE_LEFT,0,"EDGE LEFT"},
	 { BLANK_AREA_SEARCH,0,"BLANK AREA SEARCH"},
	 { READ_DATA,0,"READ DATA"}, 	
	 { WRITE_DATA,0,"WRITE DATA"} }; 	

   static num_completes = sizeof(completes)/ sizeof(struct code_struct_2);


/* ************** input_1_byte() **************************** */
/* get 1 byte of input */
input_1_byte()
   {
   char moo[1];    
   int i, return_code;
   return_code = input_byte();
   moo[0] = return_code;
   for (i = 0; i < num_returns; i++)
      if (return_code == returns[i].code) printf("%s\n", returns[i].mesg);
   if (i == num_returns) printf("%02X %.1s\n", return_code, moo);
   return(return_code);
   }

#ifdef vms
/* *************** empty_input() VMS ************************ */
/* throw out any chars in the input buffer */
empty_input() 
   {
   int temp;
   /* clear input buffer before start */
   if_fail_die(SYS$QIOW(0,chan,IO$_READVBLK | IO$M_PURGE,0,0,0,&temp, 0,0,0,0,0));
   }
#else

/* *************** empty_input() Unix ************************ */
empty_input()
{
   static struct timeval timeout = {0,0};   /* for a select poll */
   int i;
   char buf[512];
   int num = 0;
   int value;
   int readfds;
   readfds = 1 << ifile_d;
   for (;;)
      switch((value = select(32,&readfds,NULL,NULL,&timeout)))
	 {
	 case 0:
	 if (num) 
	    {
	    printf("\n... garbage in input buffer = ");
	    for (i = 0; i < num; i++) printf("%02X ", buf[i]);
	    printf("\n");
	    }
	 return(num);
	 break;

	 case -1:
	 fprintf(stderr,"Error on select\n"); exit(1);

	 case 1:
	 buf[num++] = input_byte(); break;

	 default:
	 return(num); break;
	 }
   }
#endif	/* vms else unix */

/* ************** input_bytes() *********************** */
/* if nb = 0 get input until COMPLETION or non_ACK return character is received
/* if nb != 0 get nb bytes of input */

int input_bytes(buf,nb)
int nb; /* =0 => UNTIL COMPLETE */
char *buf;
   {
   int i;
   int return_code;
   char moo[1];
   /* Note: a select on getting input from the device does not work - the read 
	    must be issued causing possible hangup in program */
   if (nb != UNTIL_COMPLETE) 
      {
      buf[0] = g_return_code;   /* first byte already read and in g_return_code */
      /*    printf("   %02X     %.1s\n", g_return_code, buf);  */
      nb--;
      for ( i =0; i < nb; i++) 
	  {
	  return_code = input_byte();
	  moo[0] = buf[i+1] = return_code;
	  /* printf("   %02X     %.1s\n", return_code, moo); */
	  }
      return(COMPLETION);
      }
   /* else only return codes should be received here  (UNTIL COMPLETE)*/
   for (;;)
      {
      return_code = input_byte();
      for (i = 0; i < num_returns; i++)
	 if (return_code == returns[i].code)
	    {
	    /* printf("%s\n", returns[i].mesg); */
	    if ( return_code == COMPLETION) return( COMPLETION); /* good */
	    if ( return_code != ACK) return(return_code);         /* boo */
	    }	 
      }
   }

/* ************** input_byte() **************************** */
/* get 1 byte of input */
input_byte()
   {
#ifdef vms
   static int no_term[2] = {0,0};   /* for no terminators */

   if_fail_die(SYS$QIOW(0,chan,IO$_READVBLK | IO$M_NOECHO | IO$M_NOFILTR,0,0,0,
				 &g_return_code, 1,0,no_term,0,0));
#else
   g_return_code = getc(ifile);
#endif
#ifdef DEBUG_IO
    fprintf(stderr,"         <== %X\n", g_return_code);
#endif
   return(g_return_code);
   }

   /* *********************** output_byte() ************************* */
   output_byte(outb) int outb;
      {
      int cmd;
      cmd = outb;
#ifdef vms
      if_fail_die(SYS$QIOW(0,chan,IO$_WRITEVBLK,0,0,0,&cmd, 1,0,0,0,0));
#else
     putc( (int)cmd, ofile);
#ifdef ultrix
     fflush(ofile);
#endif
#endif
#ifdef DEBUG_IO
    fprintf(stderr," ==> %X\n", cmd);
#endif
      }

   /* ************************* output_cmds() ************************* */
   /* output command(s) to device */
   output_cmds( cmd,num) 
   byte *cmd;
   int num;
   {
   int return_code;
   register i,j;
   char buf[256];
   return_code = ACK;
   for (i =0; i < num; i++)	/* loop outputting commands and parameters */
      {
      output_byte( (int)cmd[i]);
      for (j = 0; j < num_completes;j++) /* loop seeing if COMPLETION returned */
	 {	    
	 if (cmd[i] == completes[j].code )		/* yes */
	    {       
	    g_enter = completes[j].num_enter;
	    g_cmd = cmd[i];
	    if (g_enter) break;
	    else
	       {
	       if (( return_code = input_bytes(buf,UNTIL_COMPLETE)) == COMPLETION)
		  ; /* printf("%s COMPLETION\n", completes[j].mesg); */
	       else return( return_code);
	       }
	    break;
	    }
	 }   

      if (j == num_completes || g_enter )	/* if looking for ACK */
	 {	 
	 return_code = input_byte();
	 if(return_code  != ACK ) /* boo.. hope not an unexpected COMPLETION ?? */
	    {
	    for (j = 0; j < num_returns; j++)
	       if (return_code == returns[j].code) break;
	    if (j == num_returns);  /*   printf("X'%02X'\n", return_code); */
	    break;   /* break from Command Loop */
	    }	       
	 else		/* got ACK or COMPLETION */
	    { 
	    if (cmd[i] == ENTER && g_enter) /* waiting COMPLETION after params?*/
	       {
	       g_enter--;
	       if (!g_enter) 	 /* enough params input */
		  {
		  if (( return_code = input_bytes(buf,UNTIL_COMPLETE))!=COMPLETION)
							   break;
		  for (j = 0; j < num_completes;j++) 
		      if (g_cmd == completes[j].code )
			; /* printf("%s COMPLETION\n", completes[j].mesg);  */
		  }
	       }
	    }	    	       		  
	 }	 
      }	 /* end of Command Loop */
   return(return_code);
   }



#ifdef vms
/* ****************** setup_tty() VMS *********************** */
setup_tty(dev_name) char *dev_name;
   {
   register i;
   struct char_buf mod;

   int charac;
   static int no_term[2] = {0,0};   /* for no terminators */

   strcpy(ctr_dev, dev_name);
   ctr_dev_desc.dsc$w_length = strlen( ctr_dev);

   if_fail_die(SYS$ALLOC(&ctr_dev_desc,0,0,0,0));
   if_fail_die(SYS$ASSIGN(&ctr_dev_desc, &chan,0,0));
   if_fail_die(SYS$QIOW(0,chan,IO$_SENSEMODE,0,0,0, &orig,8,0,0,0,0));

   /* printf("%X %X\n", ((int *)&orig)[0], ((int *)&orig)[1] ); */
   mod = orig;
   mod.class = TT$_UNKNOWN;
   mod.type  = 0;   
   charac = *( (int *)mod.charac);
   /* set some characteristics */
   charac |= 
     TT$M_EIGHTBIT | TT$M_NOECHO | TT$M_PASSALL | TT$M_HALFDUP | TT$M_MODEM;
   /* reset some characteristics */
   charac &= ~(TT$M_NOTYPEAHD | TT$M_HOSTSYNC | TT$M_TTSYNC | TT$M_READSYNC ) ; 

   for (i = 0; i < 3; i++) mod.charac[i] = ((char *)&charac)[i];
   mod.page  = 0;

   /* printf("%X %X\n", ((int *)&mod)[0], ((int *)&mod)[1] ); */

   if_fail_die(SYS$QIOW(0,chan,IO$_SETMODE,0,0,0, &mod,8,TT$C_BAUD_1200,0,0,0));
   sleep(2);  /* to let set modem take effect */

   }

#else
/* ****************** setup_tty() Unix *********************** */
setup_tty(dev_name) char *dev_name;
   {
   int ofile_d;
   if (!( ofile = fopen(dev_name, "w")))
      { fprintf(stderr,"Could not open %s for write\n", dev_name); exit(1); }

   if (!( ifile = fopen( dev_name, "r")))
      { fprintf(stderr,"Could not open %s for read\n", dev_name); exit(1); }
   ofile_d = fileno(ofile);
   more_setup_tty( ofile_d);

   ifile_d = fileno(ifile);
   more_setup_tty( ifile_d);
   }


/* ***************** more_setup_tty() System V *************************** */
#ifdef SYSV
#include <termio.h>
   more_setup_tty(fil_d) int fil_d;
   {
   int ret_val;
   struct termio tty;

   ret_val = ioctl(fil_d, TCGETA, &tty);
   if (ret_val !=1) 
      {
      tty.c_cflag = B1200 | CLOCAL | CREAD | CS8;
      tty.c_lflag = 0;
      tty.c_iflag = IGNBRK | IGNPAR; 
      tty.c_oflag = 0; 
      tty.c_cc[VEOL] = 1;    /* TIME = 1 when ICANON not set in c_lflag */
      tty.c_cc[CEOF] = 1;    /* MIN  = 1 when ICANON not set in c_lflag */
      ret_val = ioctl(fil_d, TCSETA, &tty);
      }

#ifdef DEBUG_IO
   ret_val = ioctl(fil_d, TCGETA, &tty);
   if (ret_val !=1) 
      {
      fprintf(stderr,"c_iflag = %x\n", tty.c_iflag);
      fprintf(stderr,"c_oflag = %x\n", tty.c_oflag);
      fprintf(stderr,"c_cflag = %x\n", tty.c_cflag);
      fprintf(stderr,"c_lflag = %x\n", tty.c_lflag);
      fprintf(stderr,"c_line  = %x\n", tty.c_line);
      }
#endif
   }

#else     /* BSD */
/* ***************** more_setup_tty() BSD *************************** */
#include <sgtty.h>
   more_setup_tty(fil_d) int fil_d;
   {
   int ret_val;
   struct sgttyb tty;
   int ldisc = OTTYDISC;

   ioctl(fil_d,TIOCSETD, &ldisc);  /* standard tty driver */

   ret_val = ioctl(fil_d, TIOCGETP, &tty);
   if (ret_val !=1) 
      {
      tty.sg_ispeed = B1200;
      tty.sg_ospeed = B1200;
      tty.sg_flags  = RAW | CBREAK;
      ret_val = ioctl(fil_d, TIOCSETP, &tty);
      }
   }

#endif   /* ifdef SYSV else */
#endif   /* ifdef vms else */

   /* ********************** close_io() *************************** */
close_io()
   {
#ifdef vms
   if_fail_die(SYS$QIOW(0,chan,IO$_SETMODE,0,0,0, &orig,8,TT$C_BAUD_1200,0,0,0));
   if_fail_die(SYS$DASSGN(chan));
   SYS$DALLOC(&ctr_dev_desc,0);		/* will fail if allocated twice */
#else
   fclose(ofile);
   fclose(ifile);
#endif
   }
   


