/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-utils.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : utils.c  of X Interprocess Communication Benchmark
*
*
* Description : TCP/IP utilities for client and server
*
* Written by  : Dhruve Shah
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



#define MYPORT		3278
#define CLIPORT          3078
#define BUFSIZE		512
#define WHITE           " \t\n"

#include <sys/types.h>
#include <stdio.h>
#include <arpa/nameser.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/in.h>
#include <resolv.h>

extern struct state _res;
extern int h_errno;

/*********************************************************************************
 * This function reads the number of bytes to receive. It then reads packets from*
 * the sockets. It keeps reading in a loop till it has read the entire number of *
 * bytes it was supposed to read.                                                *
 *********************************************************************************/

receive_data(s, buf)
int s;
char *buf;
{
  int t, len, pos, tlen;

  if ((t = read(s, &len, 4)) < 0) bailout("read");
  else{
    /*printf("length %d\n", len);*/
    pos = 0;tlen = len;
    while(tlen > 0){
      if ((t = read(s, &buf[pos], tlen)) < 0) bailout("read");
      tlen = tlen -t; pos = pos + t;
    }
  }

  return(len);
}

/*********************************************************************************
 * This function does a write of len bytes to the socket.                        *
 *********************************************************************************/

send_data(s, buf, len)
char *buf;
int s, len;
{
  int  t;
  
  if ((t = write(s, &len, 4)) < 0)
    perror("send_date");
  else if ((t = write(s, buf, len )) < 0)
    perror( "send: warning" );
  return(t);
}

/*********************************************************************************
 * This function does a connect to the socket. Its called within client programs.*
 *********************************************************************************/

connect_to_socket(s, remote_addr)
int s;
struct sockaddr_in *remote_addr;
{
  int t;

  if ((t = connect( s, (char *)remote_addr, sizeof(*remote_addr))) < 0)
    bailout( "connect" );
  return(t);
}

/*********************************************************************************
 * This function binds the server address to the socket descriptor.              *
 *********************************************************************************/

bind_sock(sock, host_addr)
int sock;
struct sockaddr_in *host_addr;
{
  int t;

  if ((t = bind( sock, (caddr_t)host_addr, sizeof(*host_addr))) < 0)
      bailout( "bind" );
  return(t);
}

/*******************************************************************************
 * This function creates an AF_INET, SOCK_STREAM, TCP socket (an endpoint for  *
 * communication).                                                              *
 *******************************************************************************/

create_socket()
{ 
  int sock;

  if ((sock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
     bailout("socket()");
  return(sock);
}

/******************************************************************************
 * This function fills the sockaddr_in structure with information about the   *
 * server.                                                                    *
 ******************************************************************************/

mk_sock_addrin(sock_addr, host_name)
struct sockaddr_in	*sock_addr;
char * host_name;
{

  int i;
  char h[32];
  register struct hostent *hp;
  register char *s;
  gethostname(h, 32);
  s = h;

  i=0;

  while(i==0){
#ifdef DEBUG
      printf("\nServer machine name=>%s\n", host_name);
#endif
      hp = gethostbyname(host_name) ;
      if ( hp != NULL){
        i=1;
        break;
      }

      hp = gethostbyname(s);
      _res.nsaddr.sin_addr = *(struct in_addr *)hp->h_addr;
      _res.options &= ~RES_DEFNAMES;

      hp = gethostbyname(host_name) ;
      if ( hp != NULL){
        i=1;
        break;
      }
      printf("Need complete Internet destination name:");
      gets(host_name);
    }
#ifdef VERBOSE
  printanswer(hp);
#endif

  bzero( (char *) sock_addr, sizeof(*sock_addr));
  sock_addr->sin_port = MYPORT;
  bcopy((char *)hp->h_addr,
        (char *) &(sock_addr->sin_addr),
        hp->h_length);
  sock_addr->sin_family = AF_INET;
}

/******************************************************************************
 * This function fills the sockaddr_in structure with information about the   *
 * server. Its same as mk_sock_addrin except that it uses a different         *
 * TCP/IP Port. This function is used by synchronizing clients.               *
 ******************************************************************************/

mk_syn_sock(sock_addr, host_name)
struct sockaddr_in	*sock_addr;
char * host_name;
{

  int i;
  char h[32];
  register struct hostent *hp;
  register char *s;
  gethostname(h, 32);
  s = h;

  i=0;

  while(i==0){
#ifdef DEBUG
      printf("\nServer machine name=>%s\n", host_name);
#endif
      hp = gethostbyname(host_name) ;
      if ( hp != NULL){
        i=1;
        break;
      }

      hp = gethostbyname(s);
      _res.nsaddr.sin_addr = *(struct in_addr *)hp->h_addr;
      _res.options &= ~RES_DEFNAMES;

      hp = gethostbyname(host_name) ;
      if ( hp != NULL){
        i=1;
        break;
      }
      printf("Need complete Internet destination name:");
      gets(host_name);
    }
#ifdef VERBOSE
  printanswer(hp);
#endif

  bzero( (char *) sock_addr, sizeof(*sock_addr));
  sock_addr->sin_port = CLIPORT;
  bcopy((char *)hp->h_addr,
        (char *) &(sock_addr->sin_addr),
        hp->h_length);
  sock_addr->sin_family = AF_INET;
}

/*******************************************************************************
 * This function prints out the string of error messages using  perror.        *
 *******************************************************************************/

bailout( s, c)
char	*s;
int	c;
{
  perror( s );
  exit( c );
}



/***
get_file_length(fname)
char fname[30];
{
  register int fd, i, filelen=0;
  char buf[10000];

  if ( (fd = open(fname, 2)) < 0) printf("file cannot be opened\n");
  do{
    i = read(fd, buf, 10000);
    filelen  += i;
  }while(i > 0);
  close(fd);
  
  return(filelen);
}



char *fgetline( f, buf, max)
FILE    *f;
char    *buf;
int     max;
{
register int    m, gc;
register char   *b;

b = buf;
for (m=0  ;  (gc=fgetc(f)) != EOF  &&  ((char)gc) != '\n'  ;  m++)
        if (m < max)
                *b++ = (char) gc;
*b = '\0';

if (gc==EOF)
        return( (char *)NULL );
return( buf );
}


printanswer(hp)
     register struct hostent *hp;
{
  register char **cp;
  extern char *inet_ntoa();

  printf("Name: %s\n", hp->h_name);
  printf("Address: %s\n", inet_ntoa(*(struct in_addr *)hp->h_addr));
  
}

******/
