/*********************************************************************
*
* Name        : timing.c                       
*
* Version     : 2.0                            
* 
* Description : Performs the timing            
*
* Written by  : Version 1.0 by Brad Nichols                   
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department             
*               100 Institute Road, 
*               Worcester MA 01609. 
*               U.S.A         
*               (508) 831-5357
*
* Rev History :
*
************************************************************************/

#include "./timing.h"

timer_start_stop(time_data)
/**************************/
struct my_timeval *time_data; /* Time returned through this */
{
#ifdef GETTIMEOFDAY
  struct timeval  gtime_start;
  struct timezone gtzp;
  gettimeofday (&gtime_start, &gtzp);
  time_data->tv_sec = gtime_start.tv_sec;
  time_data->tv_usec = gtime_start.tv_usec;
#endif GETTIMEOFDAY

#ifdef GETRUSAGE  
  struct rusage   rusage_start;
  getrusage(RUSAGE_SELF, &rusage_start);
  time_data->user_tv_sec = rusage_start.ru_utime.tv_sec;
  time_data->user_tv_usec = rusage_start.ru_utime.tv_usec;
  time_data->user_tv_sec = rusage_start.ru_stime.tv_sec;
  time_data->user_tv_usec = rusage_start.ru_stime.tv_usec;
#endif GETRUSAGE

#ifdef FTIME
  struct timeb ftime_start;
  ftime(&ftime_start);
  time_data->tv_sec = ftime_start.time;
  time_data->tv_usec = ftime_start.millitm*1000;
#endif FTIME

#ifdef ATIME
  time_t time_start;
  time(&time_start);
  time_data->tv_sec = time_start;
  time_data->tv_usec = 0;
#endif ATIME

#ifdef TIMES
  struct tms      times_start;
  long            times_utime, times_stime;
  times(&times_start);
  time_data->user_tv_usec =1000000*times_start.tms_utime % HZ;
  time_data->user_tv_sec=(times_start.tms_utime-(times_start.tms_utime%HZ))/HZ;
  time_data->sys_tv_usec =1000000*times_start.tms_stime % HZ;
  time_data->sys_tv_sec =(times_start.tms_stime-(times_start.tms_stime%HZ))/HZ;
#endif TIMES

#ifdef CLOCK
  long            clock_start;
  clock_start = clock();
  time_data->tv_sec = 0;
  time_data->tv_usec = clock_start;
#endif CLOCK
}

void display_timing(starttime, stoptime, astring)
/***********************************************/
struct my_timeval *starttime, *stoptime;
char *astring;

{
  struct my_timeval temptime;

/* COMPUTE AND PRINT RESULT(S)*/

#ifdef GETTIMEOFDAY
  long num_msecs;
  num_msecs =(1000* (stoptime->tv_sec - starttime->tv_sec)) +
             ((stoptime->tv_usec - starttime->tv_usec)/1000);


  printf("%s \n gettimeofday results:\n Elaped time = %d msec\n ",astring,(int)num_msecs);
#endif GETTIMEOFDAY

#ifdef GETRUSAGE
  long rusage_stime,rusage_utime;
  rusage_stime =(1000* (stoptime->sys_tv_sec - starttime->sys_tv_sec)) +
             ((stoptime->sys_tv_usec - starttime->sys_tv_usec)/1000);

  rusage_utime =(1000* (stoptime->user_tv_sec - starttime->user_tv_sec)) +
             ((stoptime->user_tv_usec - starttime->user_tv_usec)/1000);

  printf("%s getrusage results:\n
	 User time   = %d msec\n   System time = %d msec\n",
	 astring,
	 (int)rusage_utime,             (int)rusage_stime);
#endif GETRUSAGE

#ifdef FTIME
  long num_msecs;
  num_msecs =(1000* (stoptime->tv_sec - starttime->tv_sec)) +
             ((stoptime->tv_usec - starttime->tv_usec)/1000);

  printf("%s \n ftime results:\n Elaped time = %d msec\n ",astring,(int)num_msecs);
#endif FTIME

#ifdef ATIME
  long num_msecs;
  num_msecs =(1000* (stoptime->tv_sec - starttime->tv_sec)) +
             ((stoptime->tv_usec - starttime->tv_usec)/1000);

  printf("%s \n time results:\n Elaped time = %d msec\n ",astring,(int)num_msecs);
#endif ATIME

#ifdef TIMES
  long times_stime,times_utime;
  times_stime =(1000* (stoptime->sys_tv_sec - starttime->sys_tv_sec));
  times_utime =(1000* (stoptime->user_tv_sec - starttime->user_tv_sec));

  printf("%s times results:\n  User time   = %d msec\n   System time = %d msec\n", astring,(int)times_utime,(int)times_stime);
#endif TIMES

#ifdef CLOCK
  long num_msecs;
  num_msecs =(stoptime->tv_usec - starttime->tv_usec)/1000;

  printf("%s \n clock results:\n Elaped time = %d msec\n ",astring,(int)num_msecs);
#endif CLOCK
}



