
/*********************************************************************
*
* Name        : server.c -- of Sftp
*
* Version     : 1.0
*
* Description : The server process is complimented by a client in transfer
*               -ing data files across machines using TCP/IP protocol.
*
* Written by  : Aju John
*
* Address     : Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5005
*
************************************************************************/

/******************************************************************
  This program is a part of a client - server data transfer system
  built to study the effect of different sizes of buffering to the
  transport interface, and to compare the file transfer performance
  using TCP/IP protocol. 
 ******************************************************************/

/* #define FSYNC  if fsync() is to be done after every write */

#define MYPORT		3277
#define BUFSIZE		512
#define MAXNAME         30

#include <sys/file.h>
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

char homedir[100];
unsigned long time_diff;

main( argc, argv)
int	argc;
char	**argv;

{
  int	tmpsock, sock, len;
  struct sockaddr_in	host_addr;
  char buf[20], *getwd();
  FILE *fopen(), *fd;
  int blocksize = BUFSIZE;

  /* Initialize the server. This call will create a TCP/IP socket and
     bind it to a known address. It then listens on that socket for
     incoming clients.  */

  sock = initialize_server(&host_addr);
  tmpsock = accept_data(sock);

  /* recive the data from the socket. First string is the
     the request from the client. Based on that call the
     appropriate routine is called. Each of these routines
     will further call receive_data to get the parameters
     associated with the request */

  do{
    receive_data(tmpsock, buf);
    if (strcmp(buf, "ls")==0)
      directory(tmpsock);
    else if (strcmp(buf, "put") == 0)
      get_file_from_client(tmpsock, blocksize);
    else if (strcmp(buf, "get") == 0)
      put_file_into_client(tmpsock, blocksize);
    else if (strcmp(buf, "chdir") == 0)
     chdirectory(tmpsock);
    else if (strcmp(buf, "buffer") == 0)
      blocksize = set_server_buffer(tmpsock, blocksize);
   }while(strcmp(buf, "quit") != 0);
   
close(sock);  

}

/* change directory */

chdirectory(tmpsock)
int tmpsock;
{
  char buf[BUFSIZE];
  int response;

  receive_data(tmpsock, buf);
  response = chdir(buf);
  send_data(tmpsock, &response, 4);
}

/* routine to set the transport buffer size */

set_server_buffer(tmpsock, oldsize)
int tmpsock;
int oldsize;
{
  char buf[BUFSIZE];
  int response;
  int newsize;

  receive_data(tmpsock, buf);
  newsize = atoi(buf);
  if  ( newsize < 63)
    {
      response = -1;
      send_data(tmpsock, &response, 4);
      return (oldsize);
    }
  else
    {
      response = 0;
      send_data(tmpsock, &response, 4);
      return (newsize);
    }
  
}

/* make a directory */

mkdirectory(tmpsock)
int tmpsock;
{
  char buf[BUFSIZE];
  int response;

  receive_data(tmpsock, buf);
  response = mkdir(buf, 700);
  send_data(tmpsock, &response, 4);
}


/* get the listing of the directory */

directory(tmpsock)
int tmpsock;
{
  char buf[BUFSIZE];
  int fd, len=1, dirlen;

  sprintf(buf, "ls -aF  > /tmp/tmp.jnk");
  system(buf);
  if ((fd = open("/tmp/tmp.jnk", 2)) < 0)
    printf("the file is not opened\n");
  dirlen = get_size("/tmp/tmp.jnk");
  send_data(tmpsock, &dirlen, 4);
  if (dirlen == 0) return;
  
  while(len > 0){
    len = read(fd, buf, BUFSIZE);
    if (len > 0)
      send_data(tmpsock, buf, len);
    else if (len < 0) printf("Reading problems encountered\n");
  }

  close(fd);
  unlink("/tmp/tmp.jnk");
}

/* routine to transfer a file from client. Invoked by a "put" request 
   from the client */

get_file_from_client(tmpsock, blocksz)
int tmpsock;
int blocksz;
{
  char *buf;
  int fd;
  long len, filelen; 
  long receive_data();
  long write_time;
  char fname[30];
  buf = (char *)malloc( blocksz +1, sizeof(char));
  if (buf == 0)
    {
      printf("malloc error");
      exit(-1);
    }
  receive_data(tmpsock, buf);
  receive_data(tmpsock, &filelen);
  strcpy(fname, buf);
  if ((fd = open(buf, 2)) < 0)
       fd = creat(buf, 0666);
  write_time = 0L;
  do{
    len = receive_data(tmpsock, buf);
    begin_timing();
    write(fd, buf, len);
#ifdef FSYNC
    fsync(fd); /* forces writes for every buffer. will slow down the
		  transfer very much */
#endif
    end_timing();
    write_time += time_diff;
    filelen  -=  len;
  }while(filelen > 0);
  printf("Write time for file %s: %d msec\n", fname , write_time);
  sprintf(buf,"%d", write_time);
  send_data(tmpsock, buf, strlen(buf));
  close(fd);
}


/* routine to service the "get" request from the client */

put_file_into_client(tmpsock, blocksz)
int tmpsock;
int blocksz;
{
  char fname[30];
  long len=1;
  FILE *fd;
  char *buf;
  int retlen;
  long read_time;

  buf = (char *)malloc( blocksz +1, sizeof(char));

  retlen = receive_data(tmpsock, fname);
  fname[retlen] = 0;
  fd = fopen(fname, "r");
  if (fd == NULL){
    len = -1; send_data(tmpsock, &len, 4);
    printf("Open error %d on file %s\n",fd,fname);
    return;
  }

  len = get_size(fname);
  send_data(tmpsock, &len, sizeof(len));
  len=1;

  read_time = 0L;


  while(len > 0){
    begin_timing();
    len = fread( buf,sizeof(*buf), blocksz,fd);
    end_timing();
    read_time += time_diff;
    if (len > 0)
      send_data(tmpsock, buf, len);
    else if (len < 0) printf("Reading problem [put]");
  }
  printf("Read time for file %s: %d msec\n", fname , read_time);
  sprintf(buf,"%d", read_time);
  send_data(tmpsock, buf, strlen(buf));
}


/* routine to accept a client's message at the socket */


accept_data(sock)
int sock;
{
  struct sockaddr_in from;
  int g, len = sizeof(from);

  g = accept(sock, &from, &len);
  if (g < 0) bailout("accept ");
  return(g);  
}

/* routine to create a socket and bin it to a known address */

initialize_server(host_addr)
struct sockaddr_in *host_addr;
{
  char host[BUFSIZE];
  int sock, t;

  gethostname(host, MAXNAME);
  mk_sock_addrin(host_addr, host);
  sock = create_socket();
  t = bind_sock(sock, host_addr);
  listen(sock, 5);
  getwd(homedir);
  return(sock);
}


