/*-=-=-=-=-=-=-=-=-=-=-=-=-sdumpdata.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/************************************************************************

      Name        : sdumpdata.c - creates data for synthetic dump  

      Written by  : Aju John  [aju@cs.wpi.edu]                         
                                                                       
      Institution : Dept of CS, Worcester Polytechnic Institute        
                                                                       
      Rev History : Written on      : July 2, 1990.                    
                    Last Modified on: July 4, 1990.                    
                    Version 1.0                                        
                                                                       
************************************************************************/

/******************************************************************
 * PRELIMINARY VERSION: Not for distribution.                     *
 * For final version, send mail to mach@cs.wpi.edu                *
 ******************************************************************/

/*
Inputs :  (command line arguments to this program)
========
First argument: The pathname to the directory to contain the test data.
                It is a set of 10 files of one megabyte size
                named file_0...file_9.

Second argument: Number of files to create: Minimum:1, Maximum 10.

*/

#define MAXNO 50000  /* records in a data file */
#define MAXFILES 99 

#include <stdio.h>


main (argc, argv)
        int     argc;
        char    *argv[];
{
        char            *path, c[5];
        int             ret, val;
	int             i;
	int		nforks;
	long            j;
        char            filename[30], diskname[30];
	char            *disk, temp[30];
	FILE            *fi;

	if (argc != 3) {
	  printf ("\nProgram %s needs 3 arguments: \n", argv[0]);
	  printf ("   Directory to put the data-files\n");
	  printf ("   Number of files to create  (Mininum: 1)\n");
	  exit(-1);
	}



        strcpy(diskname, argv[1]);


        disk = diskname;

	/* number of files to be dumped */

	nforks = atoi(argv[2]);
	if ( nforks > MAXFILES ) nforks = MAXFILES;
	if ( nforks < 1  ) nforks =  1;

	strcpy( temp, argv[1]);
	strncat(temp,"/file_",6);



	
	for (i = 0; i < nforks; i++) {
	  strcpy(disk, temp); 
	  sprintf( c, "%d", i);
	  strcat(disk, c); 

	  
	  fi = fopen(disk, "w");
	  if (fi == NULL) {
	    printf("ERROR:Cannot open %s\n", disk);
	    exit(-1);
	  }
	  printf("Creating %s\n" , disk);
	  for (j =0; j < MAXNO; j++)
	    {
	      fprintf(fi,"Data from file %4d\n",i);
	    }
	  fclose (fi);
	}


      }
	  


