/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-timing.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : timing.c
*
* Version     : 1.1
*
* Description : Common Standard Portable Timing Routine.
*
* Modified by : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*                 
************************************************************************/

/* $Log$  */

/******************************************************************
 * PRELIMINARY VERSION: Not for distribution.                     *
 * For final version, send mail to mach@cs.wpi.edu                *
 ******************************************************************/

#include <sys/types.h>
#include <sys/stat.h>


#define  START 0
#define  STOP  1

#define GETTIMEOFDAY 
/* #define FTIME    */

local_timing()

{


unsigned long return_value;

#ifdef GETTIMEOFDAY
#include <sys/time.h>
  struct timeval  lc_gtime_start;
  struct timezone lc_gt_zp;
  unsigned long   lc_gtime_elapsed;


  gettimeofday (&lc_gtime_start, &lc_gt_zp);
  lc_gtime_elapsed = (1000*lc_gtime_start.tv_sec + lc_gtime_start.tv_usec/1000);
  return_value =  lc_gtime_elapsed ;
  return (  return_value);
#endif

#ifdef FTIME
#include <sys/timeb.h>
  struct timeb    lc_ftimestart;
  unsigned long   lc_ftimesec1,  lc_ftimemillisec1;
  ftime(&lc_ftimestart);
  lc_ftimemillisec1 = lc_ftimestart.millitm;
  lc_ftimemillisec1 += lc_ftimesec1*1000;
  return (lc_ftimemillisec1 );
#endif 


  
}
