
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-cl_anl.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : cl_anl.c   / * of sdbase * /
*
* Version     : $Revision$
*
* Description : client output alanyzer porgram - Sdbase
*
* Written by  : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/




static unsigned long rd_cnt, 		/* read request counter */
	      wr_cnt,		/* write request counter */
	      ad_cnt,		/* add request counter */
	      gt_cnt,		/* get request counter */
	      rs_cnt;		/* result request counter */

unsigned long errcnt;		/* Total error count */

unsigned long time_diff;
unsigned long total_tasks;	/* Total number of tasks logged in */
unsigned long client_time;
unsigned long init_time;
unsigned long getlen_time;
unsigned long read_time;
unsigned long write_time;
unsigned long append_time;



unsigned long Cclient_time = 0;
unsigned long Cinit_time = 0;
unsigned long Cgetlen_time = 0;
unsigned long Cread_time = 0;
unsigned long Cwrite_time = 0;
unsigned long Cappend_time = 0;


#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>


main(argc, argv)
int argc;
char *argv[];

{
  int             i;
  char            c[5];
  char            disk[30];
  long      rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd, tot_ovhd;
  long      tot_client_time,
            tot_rd_cnt,tot_wr_cnt,tot_ad_cnt,tot_gt_cnt;
  long      tot_read_time, tot_write_time, tot_append_time,
            tot_getlen_time;
  long      tot_Cread_time, tot_Cwrite_time, tot_Cappend_time,
            tot_Cgetlen_time, tot_Cclient_time;
  FILE      *fp;
  int   no_of_clients;
  
  printf("*** Client data Analyzer ***\n");
  if (argc == 1)
    {
      printf("usage: %s  N, where N is the # of files to be analyzed.\n",
	     argv[0]);
      exit(-1);
    }
  tot_client_time=tot_rd_cnt=tot_wr_cnt=tot_ad_cnt=tot_gt_cnt=0L;
  tot_read_time= tot_write_time= tot_append_time= tot_getlen_time=0L;
  tot_Cclient_time = 0L;
  tot_Cread_time= tot_Cwrite_time=  tot_getlen_time = tot_Cappend_time = 0L;
  no_of_clients = atoi(argv[1]);
  
  printf("Analyzing Data for %d clients\n", no_of_clients);
  
  for(i=1; i<=no_of_clients; i++)
    {
      strcpy(disk,"dbc_");
      sprintf( c, "%d", i);
      strcat(disk, c);
      fp = fopen ( disk, "r");
      if (fp == NULL)
	{
	  printf("Error: Can't open %s\n\n", disk);
	  printf("*** Only %d files analyzed\n", i);
	  break;
	}
      fscanf(fp, " %d", &client_time);
      fscanf( fp, " %d %d %d %d",
	      &rd_cnt, &wr_cnt, &ad_cnt, &gt_cnt);
      fscanf( fp," %d %d %d %d",
	      &read_time, &write_time, &append_time, &getlen_time);
      fscanf( fp," %d %d %d %d",
	      &Cread_time, &Cwrite_time, &Cappend_time, &Cgetlen_time);
      Cclient_time =  Cgetlen_time + Cread_time + Cwrite_time +
            Cappend_time;


      fclose(fp);
  printf( "------------------Client #%d---------------------\n", i);
  printf( "\t read \t write \t append\t get_last_record \n");
  printf( "------------------------------------------------\n");
  printf( "\t %d \t %d \t %d \t %d \t(Number of operations)\n",
	 rd_cnt, wr_cnt, ad_cnt, gt_cnt);
      printf( "%13d%8d%8d%8d \t(time for each  operation in ms)\n",
	 read_time, write_time,append_time,getlen_time);
      printf( "%13d%8d%8d%8d \t(time for communication in ms)\n",
	 Cread_time,
	 Cwrite_time,
	 Cappend_time,
	 Cgetlen_time);
      printf( "\t%.2f %.2f %.2f %.2f \t(Avg time/operation in ms)\n",
	 (float)read_time/(float)rd_cnt,
	 (float)write_time/(float)wr_cnt,
	 (float)append_time/(float)ad_cnt,
	 (float)getlen_time/(float)gt_cnt);
      printf( "\t %.2f %.2f %.2f %.2f \t(Avg time for Commn )\n",
	 (float)Cread_time/(float)rd_cnt,
	 (float)Cwrite_time/(float)wr_cnt,
	 (float)Cappend_time/(float)ad_cnt,
	 (float)Cgetlen_time/(float)gt_cnt);
      printf( "------------------------------------------------\n");
      printf( "Client time = %d milliseconds\n",client_time);
      printf( "Communication time = %d milliseconds\n",Cclient_time);



      tot_client_time += client_time;
      tot_rd_cnt += rd_cnt;
      tot_wr_cnt += wr_cnt;
      tot_ad_cnt += ad_cnt;
      tot_gt_cnt += gt_cnt;
      tot_read_time += read_time;
      tot_write_time += write_time;
      tot_append_time += append_time;
      tot_getlen_time += getlen_time;
      tot_Cread_time += Cread_time;
      tot_Cwrite_time += Cwrite_time;
      tot_Cappend_time += Cappend_time;
      tot_Cgetlen_time += Cgetlen_time;
      tot_Cclient_time += Cclient_time;
    }
  printf ("\n\n\n\n");
  wpi_banner("Synthetic Database: database client", "v1.0" );
  printf( "------------------TOTAL-TIME--------------------\n");
  printf( "\t read \t write \t append\t get_last_record \n");
  printf( "------------------------------------------------\n");
  printf( "Number of operations\n");
  printf( "\t %d \t %d \t %d \t %d \n",
	 tot_rd_cnt, tot_wr_cnt, tot_ad_cnt, tot_gt_cnt);
  printf( "Total time for each  operation (Time in msecs)\n");
  printf( "%14d%8d%8d%8d \n",
	 tot_read_time, tot_write_time,tot_append_time,tot_getlen_time);
  printf( "Average time for each  operation (Time in msecs)\n");
  printf( "\t %.2f  %.2f  %.2f  %.2f \n",
	 (float)tot_read_time/(float)tot_rd_cnt,
	 (float)tot_write_time/(float)tot_wr_cnt,
	 (float)tot_append_time/(float)tot_ad_cnt,
	 (float)tot_getlen_time/(float)tot_gt_cnt);
  printf( "Average time for Communications (Time in msecs)\n");
  printf( "\t %.2f  %.2f  %.2f  %.2f \n",
	 (float)tot_Cread_time/(float)tot_rd_cnt,
	 (float)tot_Cwrite_time/(float)tot_wr_cnt,
	 (float)tot_Cappend_time/(float)tot_ad_cnt,
	 (float)tot_Cgetlen_time/(float)tot_gt_cnt);
  
  printf( "------------------------------------------------\n");
  i--;
  printf( "Total client time = %d milliseconds\n",tot_client_time);
  printf( "Normalized client time (for any client) = %d ms\n",tot_client_time/i);
  printf( "Total communication time = %d milliseconds\n",tot_Cclient_time);
  printf( "Normalized commun. time = %d ms\n",tot_Cclient_time/i);
  printf( "\n>>Results are based on the analysis of %d clients.\n", i);




  fp = fopen ( "tmp#ovhd", "r");
      if (fp == NULL)
        {
          printf("Error: Can't open temp files\n\n");
          return(1);
        }
  fscanf(fp, " %d %d %d %d %d", &rd_ovhd, &wr_ovhd, &ap_ovhd, &gt_ovhd, &tot_ovhd);
  fclose(fp);

  printf ("Lock overheads(msec):\nread:\t%8d\nwrite:\t%8d\nappend:\t%8d\ngtlast:\t%8d\n",rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd);
  tot_ovhd = rd_ovhd + wr_ovhd + ap_ovhd + gt_ovhd;
  printf("--------------------\nTotal:\t%8d msec \n", tot_ovhd);

  printf( "\n--- After lock overhead adjustments (client) ---\n");
  printf( "Total client time = %d milliseconds\n",tot_client_time - tot_ovhd);
  printf( "(Total client  time)/%d = %d ms\n",i,(tot_client_time- tot_ovhd)/i);



}



