  
/*********************************************************************
*
* Name        : solve.c
*
* Version     : 1.2
*
* Description : Jumble is called by jigsaw.c to scramble the puzzle
*               before attempting to solve it.
*
* Written by  : Aju John & Dhruve Shah.
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
* Rev History : It was modified by Aju John, in July 90 to make the 
*               scrambling sequence constant, rather than a random
*               fashion.
* $Log$
************************************************************************/
/* include files */
#include <stdio.h>
#include <math.h>
#include "glob.h"       /* file containing global declarations */
#include "defines.h"    /* file containing global definitions  */

/*****************************************************************************
 Jumble.c

 Input(s): void
 Returns : the required size of the puzzle.
 Output  : none
 routines called: none    
 $Id$                    
 ****************************************************************************/

jumble(size_of_jigsaw)
int size_of_jigsaw;

{

  SET_PTR   pair;
  TILE_PTR  *jigsaw_matrix, start, head, ptr, prev, make_random_list(); 
  int total_pairs;
  int i,j,k;
  FILE *file2, *file3;

  if (!(jigsaw_matrix = (TILE_PTR*) calloc (size_of_jigsaw, sizeof(TILE_PTR))))
    {
      printf ("Error in calloc at X01 \n");
      exit(-1);
    }
  for(i=0;i<size_of_jigsaw;i++)
    {
      jigsaw_matrix[i] = (TILE*) calloc (size_of_jigsaw, sizeof(TILE));
    }

  
  file2 = fopen("puzzle.out","r");
  if (file2 == NULL)
    {
      printf("Error: X02 - Cannot open file:puzzle.out.\n");
      exit(-1);
    }


  
  for(i=0;i<size_of_jigsaw;i++)
    for(j=0;j<size_of_jigsaw;j++)
      fscanf(file2,"%d %d %d %d %d\n",&jigsaw_matrix[i][j].identity,&jigsaw_matrix[i][j].east,&jigsaw_matrix[i][j].west,&jigsaw_matrix[i][j].north,&jigsaw_matrix[i][j].south);

  fclose(file2);


  for(i=0; i<size_of_jigsaw; i++)
    for(j=0; j<size_of_jigsaw; j++)
      {
	if (i==0  && j==0){
	  start = &jigsaw_matrix[i][j];
	  prev = start;
      }
      else{
	ptr = &jigsaw_matrix[i][j];
        prev->next = ptr;
	prev = ptr;
      }
    }
  prev->next = NULL;


  
  printf("Scrambling the list...");
  k = size_of_jigsaw * size_of_jigsaw;
  for(i=0;i<(int)k;i++)
    start = make_random_list(start, size_of_jigsaw,i);

  printf("Done.\n");
  
  file3 = fopen("jumble.out","w");
  if (file3 == NULL)
    {
      printf("Error: X02 - Cannot open file:jumble.out.\n");
      exit(-1);
    }

  head = start;
  while ( head != NULL)
  {
     fprintf(file3,"%d %d %d %d %d\n",head->identity,head->east,head->west,head->north,head->south);
      head = head->next;
  }
  fclose(file3);
}


TILE_PTR
make_random_list(head, size, position)
TILE_PTR head;
int size;
{
  TILE_PTR prev, ptr;
  long int x;

  prev = head; ptr = head;
  x = rand_size(size, position);
  if (x < 1) return(head);
  head = head->next;

  while( x > 0 ){
     ptr  = ptr->next;
     --x;
  }
  prev->next = ptr->next;
  ptr->next  = prev;

  return(head);
}


rand_size(x, position)
int x, position;
{

 register double max, max16, s1;
 long int s;
  

 max16 = x*x - 1;
 
 s = (position+(int)max16/2) % (int)max16 ;
 return(s);
}


  
